/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.GraphicsPathFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathSketchFP;
import com.guidebee.game.engine.drawing.core.LineFP;
import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.MatrixFP;
import com.guidebee.game.engine.drawing.core.PenFP;
import com.guidebee.game.engine.drawing.core.PointFP;

class GraphicsPathOutlineFP
extends GraphicsPathSketchFP {
    private int ff_rad;
    private int startLineCap;
    private int endLineCap;
    private int lineJoin;
    private boolean needDrawStartCap = false;
    private PointFP lastPoint = null;
    private LineFP lastCurveTail = null;
    private GraphicsPathFP curvePath1 = null;
    private GraphicsPathFP curvePath2 = null;
    private PointFP curveBegin = null;
    private boolean drawingCurve = false;
    private GraphicsPathFP outline;
    private PointFP startCapP1;
    private PointFP startCapP2;
    private boolean closed = true;

    public GraphicsPathOutlineFP(GraphicsPathFP outline, PenFP lineStyle) {
        this.outline = outline;
        this.ff_rad = lineStyle.width / 2;
        this.startLineCap = lineStyle.startCap;
        this.endLineCap = lineStyle.endCap;
        this.lineJoin = lineStyle.lineJoin;
    }

    @Override
    public void end() {
        this.finishCurrentSegment();
    }

    @Override
    public void moveTo(PointFP point) {
        this.finishCurrentSegment();
        this.needDrawStartCap = true;
        this.closed = false;
        this.startCapP2 = null;
        this.startCapP1 = null;
        super.moveTo(point);
    }

    @Override
    public void quadTo(PointFP control, PointFP point) {
        this.curveBegin(control);
        super.quadTo(control, point);
        this.curveEnd(control, control, point);
    }

    @Override
    public void curveTo(PointFP control1, PointFP control2, PointFP point) {
        this.curveBegin(control1);
        super.curveTo(control1, control2, point);
        this.curveEnd(control1, control2, point);
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.startCapP1 != null && this.startCapP2 != null && this.lastPoint != null && this.currPoint != null) {
            this.addLineJoin(this.startCapP1.equals(this.currPoint) ? this.lastPoint : this.currPoint, this.startCapP1, this.startCapP2);
        }
        this.lineTo(this.startPoint);
        this.started = false;
    }

    @Override
    public void lineTo(PointFP point) {
        if (point.equals(this.currPoint)) {
            return;
        }
        LineFP head = new LineFP();
        LineFP tail = new LineFP();
        this.calcHeadTail(this.currPoint, point, head, tail);
        if (this.drawingCurve) {
            if (this.lastCurveTail != null) {
                this.curvePath1.addLineTo(this.lastCurveTail.pt1);
                this.curvePath2.addLineTo(this.lastCurveTail.pt2);
            }
            this.lastCurveTail = new LineFP(tail);
        } else {
            if (this.needDrawStartCap) {
                this.startCapP1 = new PointFP(this.currPoint);
                this.startCapP2 = new PointFP(point);
                this.needDrawStartCap = false;
            }
            this.addLineJoin(this.lastPoint, this.currPoint, point);
            this.outline.addMoveTo(head.pt1);
            this.outline.addLineTo(tail.pt1);
            this.outline.addLineTo(tail.pt2);
            this.outline.addLineTo(head.pt2);
            this.outline.addLineTo(head.pt1);
            this.outline.addClose();
            this.lastPoint = new PointFP(this.currPoint);
        }
        super.lineTo(point);
    }

    private void finishCurrentSegment() {
        if (this.closed) {
            return;
        }
        if (this.startCapP1 != null && this.startCapP2 != null) {
            this.addLineCap(this.startCapP2, this.startCapP1, this.startLineCap);
        }
        if (this.lastPoint != null) {
            this.addLineCap(this.lastPoint, this.currPoint, this.endLineCap);
        }
    }

    private void addLineCap(PointFP p1, PointFP p2, int lineCap) {
        if (lineCap == 1 || p1.equals(p2)) {
            return;
        }
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        int len = PointFP.distance(dx, dy);
        PointFP[] cap = lineCap == 2 ? GraphicsPathFP.ROUNDCAP : GraphicsPathFP.SQUARECAP;
        dx = MathFP.mul(this.ff_rad, MathFP.div(dx, len));
        dy = MathFP.mul(this.ff_rad, MathFP.div(dy, len));
        MatrixFP m = new MatrixFP(dx, dx, dy, -dy, p2.x, p2.y);
        this.outline.addMoveTo(new PointFP(0, GraphicsPathFP.ONE).transform(m));
        for (int i = 0; i < cap.length; ++i) {
            this.outline.addLineTo(new PointFP(cap[i]).transform(m));
        }
        this.outline.addLineTo(new PointFP(0, -GraphicsPathFP.ONE).transform(m));
        this.outline.addClose();
    }

    private void calcHeadTail(PointFP p1, PointFP p2, LineFP head, LineFP tail) {
        LineFP curr = new LineFP(p1, p2);
        head.reset(curr.getHeadOutline(this.ff_rad));
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        tail.reset(head.pt1.x + dx, head.pt1.y + dy, head.pt2.x + dx, head.pt2.y + dy);
    }

    private void addLineJoin(PointFP lastPoint, PointFP currPoint, PointFP nextPoint) {
        if (lastPoint == null || currPoint == null || nextPoint == null || nextPoint.equals(currPoint) || lastPoint.equals(currPoint)) {
            return;
        }
        PointFP p1 = null;
        PointFP p2 = null;
        LineFP head = new LineFP();
        LineFP tail = new LineFP();
        this.calcHeadTail(currPoint, nextPoint, head, tail);
        LineFP lastHead = new LineFP();
        LineFP lastTail = new LineFP();
        this.calcHeadTail(lastPoint, currPoint, lastHead, lastTail);
        boolean needLineJoin = false;
        PointFP pi1 = new PointFP();
        PointFP pi2 = new PointFP();
        boolean cross1 = LineFP.intersects(new LineFP(head.pt1, tail.pt1), new LineFP(lastHead.pt1, lastTail.pt1), pi1);
        boolean cross2 = LineFP.intersects(new LineFP(head.pt2, tail.pt2), new LineFP(lastHead.pt2, lastTail.pt2), pi2);
        if (cross1 && !cross2 && pi1.x != -2147483647) {
            p1 = lastTail.pt2;
            p2 = head.pt2;
            needLineJoin = true;
        } else if (!cross1 && cross2 && pi2.x != -2147483647) {
            p1 = lastTail.pt1;
            p2 = head.pt1;
            needLineJoin = true;
        }
        if (needLineJoin) {
            this.outline.addMoveTo(cross1 ? pi1 : pi2);
            this.outline.addLineTo(cross1 ? p2 : p1);
            if (this.lineJoin == 1) {
                this.outline.addLineTo(cross1 ? pi2 : pi1);
            }
            this.outline.addLineTo(cross1 ? p1 : p2);
            this.outline.addClose();
            if (this.lineJoin == 2) {
                this.addLineCap(cross2 ? pi2 : pi1, currPoint, 2);
            }
        }
    }

    private void curveBegin(PointFP control) {
        this.addLineJoin(this.lastPoint, this.currPoint, control);
        this.drawingCurve = true;
        this.curvePath1 = new GraphicsPathFP();
        this.curvePath2 = new GraphicsPathFP();
        this.curveBegin = new PointFP(this.currPoint);
    }

    private void curveEnd(PointFP control1, PointFP control2, PointFP curveEnd) {
        this.drawingCurve = false;
        if (this.needDrawStartCap) {
            this.startCapP1 = new PointFP(this.curveBegin);
            this.startCapP2 = new PointFP(control1);
            this.needDrawStartCap = false;
        }
        LineFP head = new LineFP();
        LineFP tail = new LineFP();
        this.calcHeadTail(this.curveBegin, control1, head, new LineFP());
        this.outline.addMoveTo(head.pt1);
        this.outline.addPath(this.curvePath1);
        this.calcHeadTail(control2, curveEnd, new LineFP(), tail);
        this.outline.addLineTo(tail.pt1);
        this.outline.addLineTo(tail.pt2);
        this.outline.extendIfNeeded(this.curvePath1.cmdsSize, this.curvePath1.pntsSize);
        int j = this.curvePath2.pntsSize - 1;
        for (int i = this.curvePath2.cmdsSize - 1; i >= 0; --i) {
            this.outline.addLineTo(this.curvePath2.pnts[j--]);
        }
        this.outline.addLineTo(head.pt2);
        this.outline.addClose();
        this.curvePath1 = null;
        this.curvePath2 = null;
        this.lastCurveTail = null;
        this.lastPoint = new PointFP(control2);
        this.drawingCurve = false;
    }
}

