/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.drawing.geometry.Path;
import com.guidebee.game.engine.drawing.core.GraphicsPathOutlineFP;
import com.guidebee.game.engine.drawing.core.IGraphicsPathIteratorFP;
import com.guidebee.game.engine.drawing.core.LineFP;
import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.PenFP;
import com.guidebee.game.engine.drawing.core.PointFP;

public final class GraphicsPathFP {
    int[] cmds = null;
    PointFP[] pnts = null;
    int cmdsSize = 0;
    int pntsSize = 0;
    static final PointFP[] ROUNDCAP = new PointFP[7];
    static final PointFP[] SQUARECAP = new PointFP[2];
    static final int ONE = 65536;
    private static final int CMD_NOP = 0;
    private static final int CMD_MOVETO = 1;
    private static final int CMD_LINETO = 2;
    private static final int CMD_QCURVETO = 3;
    private static final int CMD_CCURVETO = 4;
    private static final int CMD_CLOSE = 6;
    private static final int BLOCKSIZE = 16;

    public GraphicsPathFP() {
        this.cmds = null;
        this.pnts = null;
        this.pntsSize = 0;
        this.cmdsSize = 0;
    }

    public GraphicsPathFP(GraphicsPathFP from) {
        this.cmdsSize = from.cmdsSize;
        this.pntsSize = from.pntsSize;
        if (this.cmdsSize > 0) {
            this.cmds = new int[this.cmdsSize];
            this.pnts = new PointFP[this.pntsSize];
            System.arraycopy(from.cmds, 0, this.cmds, 0, this.cmdsSize);
            for (int i = 0; i < this.pntsSize; ++i) {
                this.pnts[i] = new PointFP(from.pnts[i]);
            }
        }
    }

    public static GraphicsPathFP createLine(int ff_x1, int ff_y1, int ff_x2, int ff_y2) {
        GraphicsPathFP path = new GraphicsPathFP();
        path.addMoveTo(new PointFP(ff_x1, ff_y1));
        path.addLineTo(new PointFP(ff_x2, ff_y2));
        return path;
    }

    public static GraphicsPathFP createOval(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax) {
        GraphicsPathFP path = GraphicsPathFP.createArc(ff_xmin, ff_ymin, ff_xmax, ff_ymax, 0, 411774, false);
        path.addClose();
        return path;
    }

    public static GraphicsPathFP createRoundRect(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax, int ff_rx, int ff_ry) {
        int FF_PI = 205887;
        GraphicsPathFP path = new GraphicsPathFP();
        path.addMoveTo(new PointFP(ff_xmin + ff_rx, ff_ymin));
        path.addLineTo(new PointFP(ff_xmax - ff_rx, ff_ymin));
        int ff_rmax = MathFP.min(ff_xmax - ff_xmin, ff_ymax - ff_ymin) / 2;
        if (ff_rx > ff_rmax) {
            ff_rx = ff_rmax;
        }
        if (ff_ry > ff_rmax) {
            ff_ry = ff_rmax;
        }
        if (ff_rx != 0 && ff_ry != 0) {
            path.addPath(GraphicsPathFP.createArc(ff_xmax - ff_rx * 2, ff_ymin, ff_xmax, ff_ymin + ff_ry * 2, -FF_PI / 2, 0, false, false));
        }
        path.addLineTo(new PointFP(ff_xmax, ff_ymin + ff_ry));
        path.addLineTo(new PointFP(ff_xmax, ff_ymax - ff_ry));
        if (ff_rx != 0 && ff_ry != 0) {
            path.addPath(GraphicsPathFP.createArc(ff_xmax - ff_rx * 2, ff_ymax - ff_ry * 2, ff_xmax, ff_ymax, 0, FF_PI / 2, false, false));
        }
        path.addLineTo(new PointFP(ff_xmax - ff_rx, ff_ymax));
        path.addLineTo(new PointFP(ff_xmin + ff_rx, ff_ymax));
        if (ff_rx != 0 && ff_ry != 0) {
            path.addPath(GraphicsPathFP.createArc(ff_xmin, ff_ymax - ff_ry * 2, ff_xmin + ff_rx * 2, ff_ymax, FF_PI / 2, FF_PI, false, false));
        }
        path.addLineTo(new PointFP(ff_xmin, ff_ymax - ff_ry));
        path.addLineTo(new PointFP(ff_xmin, ff_ymin + ff_ry));
        if (ff_rx != 0 && ff_ry != 0) {
            path.addPath(GraphicsPathFP.createArc(ff_xmin, ff_ymin, ff_xmin + ff_rx * 2, ff_ymin + ff_ry * 2, -FF_PI, -FF_PI / 2, false, false));
        }
        path.addClose();
        return path;
    }

    public static GraphicsPathFP createSmoothCurves(PointFP[] points, int offset, int numberOfSegments, int ff_factor, boolean closed) {
        int i;
        int len = points.length;
        GraphicsPathFP path = new GraphicsPathFP();
        if (numberOfSegments < 1 || numberOfSegments > points.length - 1 || offset < 0 || offset + numberOfSegments > len - 1) {
            return path;
        }
        PointFP[] PC1s = new PointFP[points.length];
        PointFP[] PC2s = new PointFP[points.length];
        if (!closed) {
            PC1s[0] = points[0];
            PC2s[len - 1] = points[len - 1];
        } else {
            PC1s[0] = GraphicsPathFP.calcControlPoint(points[len - 1], points[0], points[1], ff_factor);
            PC2s[0] = GraphicsPathFP.calcControlPoint(points[1], points[0], points[len - 1], ff_factor);
            PC1s[len - 1] = GraphicsPathFP.calcControlPoint(points[len - 2], points[len - 1], points[0], ff_factor);
            PC2s[len - 1] = GraphicsPathFP.calcControlPoint(points[0], points[len - 1], points[len - 2], ff_factor);
        }
        for (i = 1; i < len - 1; ++i) {
            PC1s[i] = GraphicsPathFP.calcControlPoint(points[i - 1], points[i], points[i + 1], ff_factor);
            PC2s[i] = GraphicsPathFP.calcControlPoint(points[i + 1], points[i], points[i - 1], ff_factor);
        }
        path.addMoveTo(points[offset]);
        for (i = 0; i < numberOfSegments; ++i) {
            path.addCurveTo(PC1s[offset + i], PC2s[offset + i + 1], points[offset + i + 1]);
        }
        if (closed) {
            path.addCurveTo(PC1s[len - 1], PC2s[0], points[0]);
            path.addClose();
        }
        return path;
    }

    public static GraphicsPathFP createPolyline(PointFP[] points) {
        GraphicsPathFP path = new GraphicsPathFP();
        if (points.length > 0) {
            path.addMoveTo(points[0]);
            for (int i = 1; i < points.length; ++i) {
                path.addLineTo(points[i]);
            }
        }
        return path;
    }

    public static GraphicsPathFP createPolygon(PointFP[] points) {
        GraphicsPathFP path = GraphicsPathFP.createPolyline(points);
        if (points.length > 0) {
            path.addClose();
        }
        return path;
    }

    public static GraphicsPathFP createRect(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax) {
        return GraphicsPathFP.createPolygon(new PointFP[]{new PointFP(ff_xmin, ff_ymin), new PointFP(ff_xmax, ff_ymin), new PointFP(ff_xmax, ff_ymax), new PointFP(ff_xmin, ff_ymax)});
    }

    public static GraphicsPathFP createArc(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax, int ff_arg1, int ff_arg2, boolean closed) {
        return GraphicsPathFP.createArc(ff_xmin, ff_ymin, ff_xmax, ff_ymax, ff_arg1, ff_arg2, closed, true);
    }

    public static GraphicsPathFP createArc(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax, int ff_startangle, int ff_sweepangle, boolean closed, boolean standalone) {
        int segments;
        if (ff_sweepangle < 0) {
            ff_startangle += ff_sweepangle;
            ff_sweepangle = -ff_sweepangle;
        }
        if ((segments = MathFP.round(MathFP.div(4 * MathFP.abs(ff_sweepangle), 205887)) >> 16) == 0) {
            segments = 1;
        }
        GraphicsPathFP path = new GraphicsPathFP();
        int ff_darg = ff_sweepangle / segments;
        int ff_arg = ff_startangle;
        int ff_lastcos = MathFP.cos(ff_startangle);
        int ff_lastsin = MathFP.sin(ff_startangle);
        int ff_xc = (ff_xmin + ff_xmax) / 2;
        int ff_yc = (ff_ymin + ff_ymax) / 2;
        int ff_rx = (ff_xmax - ff_xmin) / 2;
        int ff_ry = (ff_ymax - ff_ymin) / 2;
        int ff_RXBETA = MathFP.mul(17381, ff_rx);
        int ff_RYBETA = MathFP.mul(17381, ff_ry);
        if (closed) {
            path.addMoveTo(new PointFP(ff_xc, ff_yc));
        }
        for (int i = 1; i <= segments; ++i) {
            ff_arg = i == segments ? ff_startangle + ff_sweepangle : ff_arg + ff_darg;
            int ff_currcos = MathFP.cos(ff_arg);
            int ff_currsin = MathFP.sin(ff_arg);
            int ff_x1 = ff_xc + MathFP.mul(ff_rx, ff_lastcos);
            int ff_y1 = ff_yc + MathFP.mul(ff_ry, ff_lastsin);
            int ff_x2 = ff_xc + MathFP.mul(ff_rx, ff_currcos);
            int ff_y2 = ff_yc + MathFP.mul(ff_ry, ff_currsin);
            if (i == 1) {
                if (closed) {
                    path.addLineTo(new PointFP(ff_x1, ff_y1));
                } else if (standalone) {
                    path.addMoveTo(new PointFP(ff_x1, ff_y1));
                }
            }
            path.addCurveTo(new PointFP(ff_x1 - MathFP.mul(ff_RXBETA, ff_lastsin), ff_y1 + MathFP.mul(ff_RYBETA, ff_lastcos)), new PointFP(ff_x2 + MathFP.mul(ff_RXBETA, ff_currsin), ff_y2 - MathFP.mul(ff_RYBETA, ff_currcos)), new PointFP(ff_x2, ff_y2));
            ff_lastcos = ff_currcos;
            ff_lastsin = ff_currsin;
        }
        if (closed) {
            path.addClose();
        }
        return path;
    }

    public void addPath(GraphicsPathFP path) {
        if (path.cmdsSize > 0) {
            this.extendIfNeeded(path.cmdsSize, path.pntsSize);
            System.arraycopy(path.cmds, 0, this.cmds, this.cmdsSize, path.cmdsSize);
            for (int i = 0; i < path.pntsSize; ++i) {
                this.pnts[i + this.pntsSize] = new PointFP(path.pnts[i]);
            }
            this.cmdsSize += path.cmdsSize;
            this.pntsSize += path.pntsSize;
        }
    }

    public void addMoveTo(PointFP point) {
        this.extendIfNeeded(1, 1);
        this.cmds[this.cmdsSize++] = 1;
        this.pnts[this.pntsSize++] = new PointFP(point);
    }

    public void addLineTo(PointFP point) {
        this.extendIfNeeded(1, 1);
        this.cmds[this.cmdsSize++] = 2;
        this.pnts[this.pntsSize++] = new PointFP(point);
    }

    public void addQuadTo(PointFP control, PointFP point) {
        if (control.equals(point)) {
            this.addLineTo(point);
            return;
        }
        this.extendIfNeeded(1, 2);
        this.cmds[this.cmdsSize++] = 3;
        this.pnts[this.pntsSize++] = new PointFP(control);
        this.pnts[this.pntsSize++] = new PointFP(point);
    }

    public void addCurveTo(PointFP control1, PointFP control2, PointFP point) {
        if (this.pnts[this.pntsSize - 1].equals(control1)) {
            this.addQuadTo(control2, point);
            return;
        }
        if (point.equals(control2)) {
            this.addQuadTo(control1, point);
            return;
        }
        this.extendIfNeeded(1, 3);
        this.cmds[this.cmdsSize++] = 4;
        this.pnts[this.pntsSize++] = new PointFP(control1);
        this.pnts[this.pntsSize++] = new PointFP(control2);
        this.pnts[this.pntsSize++] = new PointFP(point);
    }

    public void addClose() {
        this.extendIfNeeded(1, 0);
        this.cmds[this.cmdsSize++] = 6;
    }

    public GraphicsPathFP calcOutline(PenFP lineStyle) {
        GraphicsPathFP outline = new GraphicsPathFP();
        GraphicsPathOutlineFP outlineGenerator = new GraphicsPathOutlineFP(outline, lineStyle);
        this.visit(outlineGenerator);
        return outline;
    }

    public Path toPath() {
        Path path = new Path();
        int j = 0;
        block8: for (int i = 0; i < this.cmdsSize; ++i) {
            switch (this.cmds[i]) {
                case 0: {
                    continue block8;
                }
                case 1: {
                    PointFP pt = this.pnts[j++];
                    path.moveTo(pt.x >> 16, pt.y >> 16);
                    continue block8;
                }
                case 2: {
                    PointFP pt = this.pnts[j++];
                    path.lineTo(pt.x >> 16, pt.y >> 16);
                    continue block8;
                }
                case 3: {
                    PointFP pt1 = this.pnts[j++];
                    PointFP pt2 = this.pnts[j++];
                    path.quadTo(pt1.x >> 16, pt1.y >> 16, pt2.x >> 16, pt2.y >> 16);
                    continue block8;
                }
                case 4: {
                    PointFP pt1 = this.pnts[j++];
                    PointFP pt2 = this.pnts[j++];
                    PointFP pt3 = this.pnts[j++];
                    path.curveTo(pt1.x >> 16, pt1.y >> 16, pt2.x >> 16, pt2.y >> 16, pt3.x >> 16, pt3.y >> 16);
                    continue block8;
                }
                case 6: {
                    path.closePath();
                    continue block8;
                }
            }
        }
        return path;
    }

    void visit(IGraphicsPathIteratorFP iterator) {
        if (iterator != null) {
            iterator.begin();
            int j = 0;
            block8: for (int i = 0; i < this.cmdsSize; ++i) {
                switch (this.cmds[i]) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        iterator.moveTo(this.pnts[j++]);
                        continue block8;
                    }
                    case 2: {
                        iterator.lineTo(this.pnts[j++]);
                        continue block8;
                    }
                    case 3: {
                        iterator.quadTo(this.pnts[j++], this.pnts[j++]);
                        continue block8;
                    }
                    case 4: {
                        iterator.curveTo(this.pnts[j++], this.pnts[j++], this.pnts[j++]);
                        continue block8;
                    }
                    case 6: {
                        iterator.close();
                        continue block8;
                    }
                    default: {
                        return;
                    }
                }
            }
            iterator.end();
        }
    }

    private static PointFP calcControlPoint(PointFP p1, PointFP p2, PointFP p3, int ff_factor) {
        PointFP ps = new PointFP(p2.x + MathFP.mul(p2.x - p1.x, ff_factor), p2.y + MathFP.mul(p2.y - p1.y, ff_factor));
        return new LineFP(new LineFP(p2, ps).getCenter(), new LineFP(p2, p3).getCenter()).getCenter();
    }

    void extendIfNeeded(int cmdsAddNum, int pntsAddNum) {
        Object[] newdata;
        if (this.cmds == null) {
            this.cmds = new int[16];
        }
        if (this.pnts == null) {
            this.pnts = new PointFP[16];
        }
        if (this.cmdsSize + cmdsAddNum > this.cmds.length) {
            newdata = new int[this.cmds.length + (cmdsAddNum > 16 ? cmdsAddNum : 16)];
            if (this.cmdsSize > 0) {
                System.arraycopy(this.cmds, 0, newdata, 0, this.cmdsSize);
            }
            this.cmds = newdata;
        }
        if (this.pntsSize + pntsAddNum > this.pnts.length) {
            newdata = new PointFP[this.pnts.length + (pntsAddNum > 16 ? pntsAddNum : 16)];
            if (this.pntsSize > 0) {
                System.arraycopy(this.pnts, 0, newdata, 0, this.pntsSize);
            }
            this.pnts = (PointFP[])newdata;
        }
    }

    static {
        GraphicsPathFP.ROUNDCAP[0] = new PointFP(25080, 60547);
        GraphicsPathFP.ROUNDCAP[1] = new PointFP(46341, 46341);
        GraphicsPathFP.ROUNDCAP[2] = new PointFP(60547, 25080);
        GraphicsPathFP.ROUNDCAP[3] = new PointFP(ONE, 0);
        GraphicsPathFP.ROUNDCAP[4] = new PointFP(60547, -25080);
        GraphicsPathFP.ROUNDCAP[5] = new PointFP(46341, -46341);
        GraphicsPathFP.ROUNDCAP[6] = new PointFP(25080, -60547);
        GraphicsPathFP.SQUARECAP[0] = new PointFP(ONE, ONE);
        GraphicsPathFP.SQUARECAP[1] = new PointFP(ONE, -ONE);
    }
}

