/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.GraphicsPathFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathSketchFP;
import com.guidebee.game.engine.drawing.core.IGraphicsPathIteratorFP;
import com.guidebee.game.engine.drawing.core.LineFP;
import com.guidebee.game.engine.drawing.core.PointFP;

public class GraphicsPathDasherFP
extends GraphicsPathSketchFP {
    private static final int CMD_NOP = 0;
    private static final int CMD_MOVETO = 1;
    private static final int CMD_LINETO = 2;
    private static final int CMD_QCURVETO = 3;
    private static final int CMD_CCURVETO = 4;
    private static final int CMD_CLOSE = 6;
    private static final int BLOCKSIZE = 16;
    private int[] cmds = null;
    private PointFP[] pnts = null;
    private int cmdsSize = 0;
    private int pntsSize = 0;
    private GraphicsPathFP fromPath;
    private int[] dashArray = null;
    private int dashIndex = 0;
    private int nextDistance = -1;
    private boolean isEmpty = false;

    public GraphicsPathDasherFP(GraphicsPathFP from, int[] dashArray, int offset) {
        this.fromPath = new GraphicsPathFP(from);
        int arrayLength = dashArray.length - offset;
        if (arrayLength > 1) {
            this.pnts = new PointFP[16];
            this.cmds = new int[16];
            this.dashArray = new int[dashArray.length - offset];
            System.arraycopy(dashArray, offset, this.dashArray, 0, dashArray.length);
            this.VisitPath(this);
        }
    }

    public GraphicsPathFP GetDashedGraphicsPath() {
        if (this.dashArray == null) {
            return this.fromPath;
        }
        GraphicsPathFP dashedPath = new GraphicsPathFP();
        LineFP lineFP = new LineFP();
        int j = 0;
        block5: for (int i = 0; i < this.cmdsSize; ++i) {
            switch (this.cmds[i]) {
                case 1: {
                    dashedPath.addMoveTo(this.pnts[j++]);
                    continue block5;
                }
                case 2: {
                    int pointIndex = j++;
                    lineFP.reset(this.pnts[pointIndex - 1], this.pnts[pointIndex]);
                    this.DashLine(dashedPath, lineFP);
                    continue block5;
                }
                case 6: {
                    dashedPath.addClose();
                }
            }
        }
        return dashedPath;
    }

    @Override
    public void moveTo(PointFP point) {
        super.moveTo(point);
        this.ExtendIfNeeded(1, 1);
        this.addMoveTo(point);
    }

    @Override
    public void lineTo(PointFP point) {
        super.lineTo(point);
        this.ExtendIfNeeded(1, 1);
        this.addLineTo(point);
    }

    @Override
    public void close() {
        super.close();
        this.ExtendIfNeeded(1, 0);
        this.addClose();
    }

    private void addMoveTo(PointFP point) {
        this.cmds[this.cmdsSize++] = 1;
        this.pnts[this.pntsSize++] = new PointFP(point);
    }

    private void addLineTo(PointFP point) {
        this.cmds[this.cmdsSize++] = 2;
        this.pnts[this.pntsSize++] = new PointFP(point);
    }

    private void addClose() {
        this.cmds[this.cmdsSize++] = 6;
    }

    private void ExtendIfNeeded(int cmdsAddNum, int pntsAddNum) {
        Object[] newdata;
        if (this.cmds == null) {
            this.cmds = new int[16];
        }
        if (this.pnts == null) {
            this.pnts = new PointFP[16];
        }
        if (this.cmdsSize + cmdsAddNum > this.cmds.length) {
            newdata = new int[this.cmds.length + (cmdsAddNum > 16 ? cmdsAddNum : 16)];
            if (this.cmdsSize > 0) {
                System.arraycopy(this.cmds, 0, newdata, 0, this.cmdsSize);
            }
            this.cmds = newdata;
        }
        if (this.pntsSize + pntsAddNum > this.pnts.length) {
            newdata = new PointFP[this.pnts.length + (pntsAddNum > 16 ? pntsAddNum : 16)];
            if (this.pntsSize > 0) {
                System.arraycopy(this.pnts, 0, newdata, 0, this.pntsSize);
            }
            this.pnts = (PointFP[])newdata;
        }
    }

    private void DashLine(GraphicsPathFP path, LineFP line) {
        if (this.nextDistance < 0) {
            this.nextDistance = this.dashArray[this.dashIndex];
            this.dashIndex = (this.dashIndex + 1) % this.dashArray.length;
        }
        int distance = this.nextDistance;
        PointFP pt = line.getPointAtDistance(distance);
        while (pt != null) {
            if (this.isEmpty) {
                path.addMoveTo(pt);
            } else {
                path.addLineTo(pt);
            }
            this.isEmpty = !this.isEmpty;
            this.nextDistance += this.dashArray[this.dashIndex];
            distance = this.nextDistance;
            pt = line.getPointAtDistance(distance);
            this.dashIndex = (this.dashIndex + 1) % this.dashArray.length;
        }
        if (this.isEmpty) {
            path.addMoveTo(line.pt2);
        } else {
            path.addLineTo(line.pt2);
        }
        this.nextDistance -= line.getLength();
    }

    private void VisitPath(IGraphicsPathIteratorFP iterator) {
        if (iterator != null) {
            iterator.begin();
            int j = 0;
            block8: for (int i = 0; i < this.fromPath.cmdsSize; ++i) {
                switch (this.fromPath.cmds[i]) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        iterator.moveTo(this.fromPath.pnts[j++]);
                        continue block8;
                    }
                    case 2: {
                        iterator.lineTo(this.fromPath.pnts[j++]);
                        continue block8;
                    }
                    case 3: {
                        iterator.quadTo(this.fromPath.pnts[j++], this.fromPath.pnts[j++]);
                        continue block8;
                    }
                    case 4: {
                        iterator.curveTo(this.fromPath.pnts[j++], this.fromPath.pnts[j++], this.fromPath.pnts[j++]);
                        continue block8;
                    }
                    case 6: {
                        iterator.close();
                        continue block8;
                    }
                    default: {
                        return;
                    }
                }
            }
            iterator.end();
        }
    }
}

