/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.BrushFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathDasherFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathRendererFP;
import com.guidebee.game.engine.drawing.core.MatrixFP;
import com.guidebee.game.engine.drawing.core.PenFP;
import com.guidebee.game.engine.drawing.core.PointFP;
import com.guidebee.game.engine.drawing.core.SolidBrushFP;

public final class GraphicsFP {
    public static final int MODE_XOR = 1;
    public static final int MODE_ZERO = 2;
    private PenFP lineStyle;
    private BrushFP fillStyle;
    private GraphicsPathRendererFP renderer = new GraphicsPathRendererFP();
    private int paintMode;
    private MatrixFP matrix = null;

    public GraphicsFP() {
        this.initBlock();
    }

    public GraphicsFP(int width, int height) {
        this.initBlock();
        this.resize(width, height);
    }

    public int[] getRGB() {
        return this.renderer.buffer;
    }

    public BrushFP getBrush() {
        return this.fillStyle;
    }

    public void setBrush(BrushFP value) {
        this.fillStyle = value;
    }

    public PenFP getPen() {
        return this.lineStyle;
    }

    public void setPen(PenFP value) {
        this.lineStyle = value;
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    public void setPaintMode(int value) {
        this.paintMode = value;
    }

    public MatrixFP getMatrix() {
        return this.matrix;
    }

    public void setMatrix(MatrixFP value) {
        this.matrix = value == null ? null : new MatrixFP(value);
    }

    public void resize(int width, int height) {
        this.renderer.reset(width, height);
    }

    public void clear(int color) {
        this.renderer.clear(color);
    }

    public void drawLine(int ff_x1, int ff_y1, int ff_x2, int ff_y2) {
        this.drawPath(GraphicsPathFP.createLine(ff_x1, ff_y1, ff_x2, ff_y2));
    }

    public void drawPolyline(PointFP[] points) {
        this.drawPath(GraphicsPathFP.createPolyline(points));
    }

    public void drawPolygon(PointFP[] points) {
        this.drawPath(GraphicsPathFP.createPolygon(points));
    }

    public void drawCurves(PointFP[] points, int offset, int numberOfSegments, int ff_factor) {
        this.drawPath(GraphicsPathFP.createSmoothCurves(points, offset, numberOfSegments, ff_factor, false));
    }

    public void drawClosedCurves(PointFP[] points, int offset, int numberOfSegments, int ff_factor) {
        this.drawPath(GraphicsPathFP.createSmoothCurves(points, offset, numberOfSegments, ff_factor, true));
    }

    public void drawRoundRect(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax, int ff_rx, int ff_ry) {
        this.drawPath(GraphicsPathFP.createRoundRect(ff_xmin, ff_ymin, ff_xmax, ff_ymax, ff_rx, ff_ry));
    }

    public void drawRect(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax) {
        this.drawPath(GraphicsPathFP.createRect(ff_xmin, ff_ymin, ff_xmax, ff_ymax));
    }

    public void drawOval(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax) {
        this.drawPath(GraphicsPathFP.createOval(ff_xmin, ff_ymin, ff_xmax, ff_ymax));
    }

    public void drawArc(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax, int ff_startangle, int ff_sweepangle) {
        this.drawPath(GraphicsPathFP.createArc(ff_xmin, ff_ymin, ff_xmax, ff_ymax, ff_startangle, ff_sweepangle, false));
    }

    public void drawPie(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax, int ff_startangle, int ff_sweepangle) {
        this.drawPath(GraphicsPathFP.createArc(ff_xmin, ff_ymin, ff_xmax, ff_ymax, ff_startangle, ff_sweepangle, true));
    }

    public void drawPath(GraphicsPathFP path) {
        if (this.lineStyle.dashArray != null) {
            PenFP newlineStyle = new PenFP(this.lineStyle.brush, this.lineStyle.width, 1, 1, 1);
            newlineStyle.dashArray = this.lineStyle.dashArray;
            GraphicsPathDasherFP dasher = new GraphicsPathDasherFP(path, newlineStyle.dashArray, 0);
            GraphicsPathFP newPath = dasher.GetDashedGraphicsPath();
            this.renderer.drawPath(newPath.calcOutline(newlineStyle), this.matrix, this.lineStyle.brush, 2);
        } else {
            this.renderer.drawPath(path.calcOutline(this.lineStyle), this.matrix, this.lineStyle.brush, 2);
        }
    }

    public void fillClosedCurves(PointFP[] points, int offset, int numberOfSegments, int ff_factor) {
        this.fillPath(GraphicsPathFP.createSmoothCurves(points, offset, numberOfSegments, ff_factor, true));
    }

    public void fillPolygon(PointFP[] points) {
        this.fillPath(GraphicsPathFP.createPolygon(points));
    }

    public void fillRoundRect(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax, int ff_rx, int ff_ry) {
        this.fillPath(GraphicsPathFP.createRoundRect(ff_xmin, ff_ymin, ff_xmax, ff_ymax, ff_rx, ff_ry));
    }

    public void fillRect(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax) {
        GraphicsPathFP path = GraphicsPathFP.createRect(ff_xmin, ff_ymin, ff_xmax, ff_ymax);
        path.addClose();
        this.fillPath(path);
    }

    public void fillOval(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax) {
        GraphicsPathFP path = GraphicsPathFP.createOval(ff_xmin, ff_ymin, ff_xmax, ff_ymax);
        path.addClose();
        this.fillPath(path);
    }

    public void fillPie(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax, int ff_startangle, int ff_sweepangle) {
        this.fillPath(GraphicsPathFP.createArc(ff_xmin, ff_ymin, ff_xmax, ff_ymax, ff_startangle, ff_sweepangle, true));
    }

    public void fillPath(GraphicsPathFP path) {
        this.renderer.drawPath(path, this.matrix, this.fillStyle, this.paintMode);
    }

    public int getClipHeight() {
        return this.renderer.clipHeight;
    }

    public int getClipWidth() {
        return this.renderer.clipWidth;
    }

    public int getClipX() {
        return this.renderer.clipX;
    }

    public int getClipY() {
        return this.renderer.clipY;
    }

    public void setClip(int x, int y, int width, int height) {
        this.renderer.setClip(x, y, width, height);
    }

    public void finalizeBuffer(int color) {
        this.renderer.finalizeBuffer(color);
    }

    private void initBlock() {
        this.lineStyle = new PenFP(0, 65536);
        this.fillStyle = new SolidBrushFP(0);
        this.paintMode = 1;
    }
}

