/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.collections;

import com.guidebee.game.engine.math.IComparableEx;
import com.guidebee.game.engine.math.IComparatorEx;

public class Arrays {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    private Arrays() {
    }

    public static void sort(long[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(int[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(short[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(char[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(byte[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(double[] a) {
        Arrays.sort2(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort2(a, fromIndex, toIndex);
    }

    public static void sort(float[] a) {
        Arrays.sort2(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort2(a, fromIndex, toIndex);
    }

    private static void sort2(double[] a, int fromIndex, int toIndex) {
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                double swap = a[i];
                a[i] = a[--n];
                a[n] = swap;
                continue;
            }
            if (a[i] == 0.0 && Double.doubleToLongBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0;
                ++numNegZeros;
            }
            ++i;
        }
        Arrays.sort1(a, fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = Arrays.binarySearch0(a, fromIndex, n, 0.0);
            while (--j >= 0 && a[j] == 0.0) {
            }
            for (int k = 0; k < numNegZeros; ++k) {
                a[++j] = -0.0;
            }
        }
    }

    private static void sort2(float[] a, int fromIndex, int toIndex) {
        int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                float swap = a[i];
                a[i] = a[--n];
                a[n] = swap;
                continue;
            }
            if (a[i] == 0.0f && Float.floatToIntBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0f;
                ++numNegZeros;
            }
            ++i;
        }
        Arrays.sort1(a, fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = Arrays.binarySearch0(a, fromIndex, n, 0.0f);
            while (--j >= 0 && a[j] == 0.0f) {
            }
            for (int k = 0; k < numNegZeros; ++k) {
                a[++j] = -0.0f;
            }
        }
    }

    private static void sort1(long[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        long v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(int[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        int v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(short[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        short v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(short[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(short[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(char[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        char v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(char[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(char[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(byte[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        byte v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(byte[] x, int a, int b) {
        byte t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(byte[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(byte[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(double[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(float[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        float v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(float[] x, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(float[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(float[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public static void sort(Object[] a) {
        int len = a.length;
        Object[] aux = new Object[len];
        for (int i = 0; i < len; ++i) {
            aux[i] = a[i];
        }
        Arrays.mergeSort(aux, a, 0, a.length, 0);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Object[] aux = Arrays.copyOfRange(a, fromIndex, toIndex);
        Arrays.mergeSort(aux, a, fromIndex, toIndex, -fromIndex);
    }

    public static void sort(Object[] a, IComparatorEx c) {
        int len = a.length;
        Object[] aux = new Object[len];
        for (int i = 0; i < len; ++i) {
            aux[i] = a[i];
        }
        if (c == null) {
            Arrays.mergeSort(aux, a, 0, a.length, 0);
        } else {
            Arrays.mergeSort(aux, a, 0, a.length, 0, c);
        }
    }

    public static void sort(Object[] a, int fromIndex, int toIndex, IComparatorEx c) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Object[] aux = Arrays.copyOfRange(a, fromIndex, toIndex);
        if (c == null) {
            Arrays.mergeSort(aux, a, fromIndex, toIndex, -fromIndex);
        } else {
            Arrays.mergeSort(aux, a, fromIndex, toIndex, -fromIndex, c);
        }
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && ((IComparableEx)dest[j - 1]).compareTo(dest[j]) > 0; --j) {
                    Arrays.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        Arrays.mergeSort(dest, src, low, mid, -off);
        Arrays.mergeSort(dest, src, mid, high, -off);
        if (((IComparableEx)src[mid - 1]).compareTo(src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && ((IComparableEx)src[p]).compareTo(src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off, IComparatorEx c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Arrays.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        Arrays.mergeSort(dest, src, low, mid, -off, c);
        Arrays.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static int binarySearch(long[] a, long key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(long[] a, int fromIndex, int toIndex, long key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(long[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(int[] a, int key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(short[] a, short key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(short[] a, int fromIndex, int toIndex, short key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(short[] a, int fromIndex, int toIndex, short key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(char[] a, char key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(char[] a, int fromIndex, int toIndex, char key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(char[] a, int fromIndex, int toIndex, char key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(byte[] a, byte key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(byte[] a, int fromIndex, int toIndex, byte key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(byte[] a, int fromIndex, int toIndex, byte key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(double[] a, double key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(double[] a, int fromIndex, int toIndex, double key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(double[] a, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            double midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(float[] a, float key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(float[] a, int fromIndex, int toIndex, float key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(float[] a, int fromIndex, int toIndex, float key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            float midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                int keyBits;
                int midBits = Float.floatToIntBits(midVal);
                int n = midBits == (keyBits = Float.floatToIntBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(Object[] a, Object key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(Object[] a, int fromIndex, int toIndex, Object key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(Object[] a, int fromIndex, int toIndex, Object key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            IComparableEx midVal = (IComparableEx)a[mid];
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(Object[] a, Object key, IComparatorEx c) {
        return Arrays.binarySearch0(a, 0, a.length, key, c);
    }

    public static int binarySearch(Object[] a, int fromIndex, int toIndex, Object key, IComparatorEx c) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key, c);
    }

    private static int binarySearch0(Object[] a, int fromIndex, int toIndex, Object key, IComparatorEx c) {
        if (c == null) {
            return Arrays.binarySearch0(a, fromIndex, toIndex, key);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static boolean equals(long[] a, long[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] a, int[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] a, short[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a, char[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] a, boolean[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] a, double[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Double.doubleToLongBits(a[i]) == Double.doubleToLongBits(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] a, float[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Float.floatToIntBits(a[i]) == Float.floatToIntBits(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object o1 = a[i];
            Object o2 = a2[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public static void fill(long[] a, long val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(int[] a, int val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(short[] a, short val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(char[] a, char val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(byte[] a, byte val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(double[] a, double val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(float[] a, float val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(Object[] a, Object val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static Object[] copyOf(Object[] original, int newLength) {
        Object[] copy = new Object[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static short[] copyOf(short[] original, int newLength) {
        short[] copy = new short[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static long[] copyOf(long[] original, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static float[] copyOf(float[] original, int newLength) {
        float[] copy = new float[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        boolean[] copy = new boolean[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static short[] copyOfRange(short[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        short[] copy = new short[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static int[] copyOfRange(int[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        int[] copy = new int[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static long[] copyOfRange(long[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        long[] copy = new long[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        char[] copy = new char[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static float[] copyOfRange(float[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        float[] copy = new float[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static double[] copyOfRange(double[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        double[] copy = new double[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static boolean[] copyOfRange(boolean[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        boolean[] copy = new boolean[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static Object[] copyOfRange(Object[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = new Object[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

