/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.assets.loaders;

import com.guidebee.game.engine.assets.AssetDescriptor;
import com.guidebee.game.engine.assets.AssetLoaderParameters;
import com.guidebee.game.engine.assets.AssetManager;
import com.guidebee.game.engine.assets.loaders.AsynchronousAssetLoader;
import com.guidebee.game.engine.assets.loaders.FileHandleResolver;
import com.guidebee.game.files.FileHandle;
import com.guidebee.game.graphics.TextureAtlas;
import com.guidebee.game.ui.Skin;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.ObjectMap;

public class SkinLoader
extends AsynchronousAssetLoader<Skin, SkinParameter> {
    public SkinLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SkinParameter parameter) {
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        if (parameter == null) {
            deps.add(new AssetDescriptor<TextureAtlas>(file.pathWithoutExtension() + ".atlas", TextureAtlas.class));
        } else if (parameter.textureAtlasPath != null) {
            deps.add(new AssetDescriptor<TextureAtlas>(parameter.textureAtlasPath, TextureAtlas.class));
        }
        return deps;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SkinParameter parameter) {
    }

    @Override
    public Skin loadSync(AssetManager manager, String fileName, FileHandle file, SkinParameter parameter) {
        ObjectMap<String, Object> resources;
        String textureAtlasPath;
        if (parameter == null) {
            textureAtlasPath = file.pathWithoutExtension() + ".atlas";
            resources = null;
        } else {
            textureAtlasPath = parameter.textureAtlasPath;
            resources = parameter.resources;
        }
        TextureAtlas atlas = manager.get(textureAtlasPath, TextureAtlas.class);
        Skin skin = new Skin(atlas);
        if (resources != null) {
            for (ObjectMap.Entry<String, Object> entry : resources.entries()) {
                skin.add((String)entry.key, entry.value);
            }
        }
        skin.load(file);
        return skin;
    }

    public static class SkinParameter
    extends AssetLoaderParameters<Skin> {
        public final String textureAtlasPath;
        public final ObjectMap<String, Object> resources;

        public SkinParameter() {
            this(null, null);
        }

        public SkinParameter(String textureAtlasPath) {
            this(textureAtlasPath, null);
        }

        public SkinParameter(String textureAtlasPath, ObjectMap<String, Object> resources) {
            this.textureAtlasPath = textureAtlasPath;
            this.resources = resources;
        }
    }
}

