/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.assets.loaders;

import com.guidebee.game.engine.assets.AssetDescriptor;
import com.guidebee.game.engine.assets.AssetLoaderParameters;
import com.guidebee.game.engine.assets.AssetManager;
import com.guidebee.game.engine.assets.loaders.FileHandleResolver;
import com.guidebee.game.engine.assets.loaders.SynchronousAssetLoader;
import com.guidebee.game.files.FileHandle;
import com.guidebee.game.graphics.ParticleEffect;
import com.guidebee.game.graphics.TextureAtlas;
import com.guidebee.utils.collections.Array;

public class ParticleEffectLoader
extends SynchronousAssetLoader<ParticleEffect, ParticleEffectParameter> {
    public ParticleEffectLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public ParticleEffect load(AssetManager am, String fileName, FileHandle file, ParticleEffectParameter param) {
        ParticleEffect effect = new ParticleEffect();
        if (param != null && param.atlasFile != null) {
            effect.load(file, am.get(param.atlasFile, TextureAtlas.class), param.atlasPrefix);
        } else if (param != null && param.imagesDir != null) {
            effect.load(file, param.imagesDir);
        } else {
            effect.load(file, file.parent());
        }
        return effect;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, ParticleEffectParameter param) {
        Array<AssetDescriptor<TextureAtlas>> deps = null;
        if (param != null && param.atlasFile != null) {
            deps = new Array<AssetDescriptor<TextureAtlas>>();
            deps.add(new AssetDescriptor<TextureAtlas>(param.atlasFile, TextureAtlas.class));
        }
        return deps;
    }

    public static class ParticleEffectParameter
    extends AssetLoaderParameters<ParticleEffect> {
        public String atlasFile;
        public String atlasPrefix;
        public FileHandle imagesDir;
    }
}

