/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game;

import com.guidebee.game.Application;
import com.guidebee.game.Audio;
import com.guidebee.game.Files;
import com.guidebee.game.Graphics;
import com.guidebee.game.Input;
import com.guidebee.game.Net;
import com.guidebee.game.ResourceManager;
import com.guidebee.game.engine.drawing.parser.NumberListParser;
import com.guidebee.game.engine.graphics.opengles.IGL20;
import com.guidebee.game.engine.graphics.opengles.IGL30;
import com.guidebee.game.physics.World;

public class GameEngine {
    public static Application app;
    public static Graphics graphics;
    public static Audio audio;
    public static Input input;
    public static Files files;
    public static Net net;
    public static World world;
    public static ResourceManager assetManager;
    public static IGL20 gl;
    public static IGL20 gl20;
    public static IGL30 gl30;
    public static float pixelToBox2DUnit;
    private static final NumberListParser numberListParser;
    public static int VelocityIterations;
    public static int positionIterations;

    public static float toBox2D(float pixel) {
        return pixel / pixelToBox2DUnit;
    }

    public static float[] toBox2DVertices(float[] vertices) {
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = GameEngine.toBox2D(vertices[i]);
        }
        return vertices;
    }

    public static float[] toPixelVertices(float[] vertices) {
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = GameEngine.toPixel(vertices[i]);
        }
        return vertices;
    }

    public static float toPixel(float box2d) {
        return box2d * pixelToBox2DUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[] getVerticesFromString(String input) {
        NumberListParser numberListParser = GameEngine.numberListParser;
        synchronized (numberListParser) {
            float[] coords = GameEngine.numberListParser.parseNumberList(input);
            return coords;
        }
    }

    static {
        pixelToBox2DUnit = 32.0f;
        numberListParser = new NumberListParser();
        VelocityIterations = 6;
        positionIterations = 3;
    }
}

