/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

abstract class MathFP {
    public static final int DEFAULT_PRECISION = 20;
    public static long ONE;
    public static long HALF;
    public static long TWO;
    public static long E;
    public static long PI;
    public static long PI_HALF;
    public static long PI_TWO;
    private static int ATAN2_ZERO_ERROR;
    private static final int MAX_PRECISION = 30;
    public static final int INFINITY = Integer.MAX_VALUE;
    private static final int E_PRECISION = 29;
    private static final int E_VALUE = 1459366444;
    private static final int PI_PRECISION = 29;
    private static final int PI_VALUE = 1686629713;
    private static long precision;
    private static long fracMask;
    private static long oneEightyOverPi;
    private static long piOverOneEighty;
    private static long maxDigitsCount;
    private static long maxDigitsMul;
    private static final int SK_PRECISION = 31;
    private static final int[] SK_VALUE;
    private static int[] SK;
    private static final int AS_PRECISION = 30;
    private static final int[] AS_VALUE;
    private static int[] AS;
    private static final int LN2_PRECISION = 30;
    private static final int LN2_VALUE = 744261117;
    private static final int LN2_INV_VALUE = 1549082004;
    private static int LN2;
    private static int LN2_INV;
    private static final int LG_PRECISION = 31;
    private static final int[] LG_VALUE;
    private static int[] LG;
    private static final int EXP_P_PRECISION = 31;
    private static final int[] EXP_P_VALUE;
    private static int[] EXP_P;

    MathFP() {
    }

    public static int getPrecision() {
        return (int)precision;
    }

    public static void setPrecision(int precision) {
        int i;
        if (precision > 30 || precision < 0) {
            return;
        }
        MathFP.precision = precision;
        ONE = 1 << precision;
        HALF = ONE >> 1;
        TWO = ONE << 1;
        PI = precision <= 29 ? (long)(1686629713 >> 29 - precision) : (long)(1686629713 << precision - 29);
        PI_HALF = PI >> 1;
        PI_TWO = PI << 1;
        E = precision <= 29 ? (long)(1459366444 >> 29 - precision) : (long)(1459366444 >> precision - 29);
        for (i = 0; i < SK_VALUE.length; ++i) {
            MathFP.SK[i] = precision <= 31 ? SK_VALUE[i] >> 31 - precision : SK_VALUE[i] << precision - 31;
        }
        for (i = 0; i < AS_VALUE.length; ++i) {
            MathFP.AS[i] = precision <= 30 ? AS_VALUE[i] >> 30 - precision : AS_VALUE[i] << precision - 30;
        }
        LN2 = precision <= 30 ? 744261117 >> 30 - precision : 744261117 << precision - 30;
        LN2_INV = precision <= 30 ? 1549082004 >> 30 - precision : 1549082004 << precision - 30;
        for (i = 0; i < LG_VALUE.length; ++i) {
            MathFP.LG[i] = precision <= 31 ? LG_VALUE[i] >> 31 - precision : LG_VALUE[i] << precision - 31;
        }
        for (i = 0; i < EXP_P_VALUE.length; ++i) {
            MathFP.EXP_P[i] = precision <= 31 ? EXP_P_VALUE[i] >> 31 - precision : EXP_P_VALUE[i] << precision - 31;
        }
        fracMask = ONE - 1L;
        piOverOneEighty = MathFP.div(PI, MathFP.toFP(180));
        oneEightyOverPi = MathFP.div(MathFP.toFP(180), PI);
        maxDigitsMul = 1L;
        maxDigitsCount = 0L;
        long j = ONE;
        while (j != 0L) {
            j /= 10L;
            maxDigitsMul *= 10L;
            ++maxDigitsCount;
        }
    }

    public static long convert(long fp, int precision) {
        long xabs = Math.abs(fp);
        if (precision > 30 || precision < 0) {
            return fp;
        }
        long num = (long)precision > MathFP.precision ? xabs >> (int)((long)precision - MathFP.precision) : xabs << (int)(MathFP.precision - (long)precision);
        if (fp < 0L) {
            num = -num;
        }
        return num;
    }

    public static long toFP(int i) {
        return i < 0 ? (long)(-(-i << (int)precision)) : (long)(i << (int)precision);
    }

    public static long toFP(String s) {
        long integer;
        int index;
        long frac = 0L;
        String fracString = null;
        boolean neg = false;
        if (s.charAt(0) == '-') {
            neg = true;
            s = s.substring(1);
        }
        if ((index = s.indexOf(46)) < 0) {
            integer = Integer.parseInt(s);
        } else if (index == 0) {
            integer = 0L;
            fracString = s.substring(1);
        } else if (index == s.length() - 1) {
            integer = Integer.parseInt(s.substring(0, index));
        } else {
            integer = Integer.parseInt(s.substring(0, index));
            fracString = s.substring(index + 1);
        }
        if (fracString != null) {
            if ((long)fracString.length() > maxDigitsCount) {
                fracString = fracString.substring(0, (int)maxDigitsCount);
            }
            if (fracString.length() > 0) {
                frac = Integer.parseInt(fracString);
                for (long i = maxDigitsCount - (long)fracString.length(); i > 0L; --i) {
                    frac *= 10L;
                }
            }
        }
        long fp = (integer << (int)precision) + (frac << (int)(precision + HALF)) / maxDigitsMul;
        if (neg) {
            fp = -fp;
        }
        return fp;
    }

    public static int toInt(long fp) {
        return (int)(fp < 0L ? -(-fp >> (int)precision) : fp >> (int)precision);
    }

    public static String toString(long fp) {
        long len;
        boolean neg = false;
        if (fp < 0L) {
            neg = true;
            fp = -fp;
        }
        long integer = fp >> (int)precision;
        long fp1 = (fp & fracMask) * maxDigitsMul;
        long fp2 = fp1 >> (int)precision;
        String fracString = String.valueOf(fp2);
        for (long i = len = maxDigitsCount - (long)fracString.length(); i > 0L; --i) {
            fracString = "0" + fracString;
        }
        if (neg && integer != 0L) {
            integer = -integer;
        }
        return String.valueOf(integer) + "." + fracString.toString();
    }

    public static long ceil(long fp) {
        boolean neg = false;
        if (fp < 0L) {
            fp = -fp;
            neg = true;
        }
        if ((fp & fracMask) == 0L) {
            return neg ? -fp : fp;
        }
        if (neg) {
            return -(fp & (fracMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return (fp & (fracMask ^ 0xFFFFFFFFFFFFFFFFL)) + ONE;
    }

    public static long floor(long fp) {
        boolean neg = false;
        if (fp < 0L) {
            fp = -fp;
            neg = true;
        }
        if ((fp & fracMask) == 0L) {
            return neg ? -fp : fp;
        }
        if (neg) {
            return -(fp & (fracMask ^ 0xFFFFFFFFFFFFFFFFL)) - ONE;
        }
        return fp & (fracMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long trunc(long fp) {
        return fp < 0L ? -(-fp & (fracMask ^ 0xFFFFFFFFFFFFFFFFL)) : fp & (fracMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long frac(long fp) {
        return fp < 0L ? -(-fp & fracMask) : fp & fracMask;
    }

    public static int fracAsInt(long fp) {
        if (fp < 0L) {
            fp = -fp;
        }
        return (int)(maxDigitsMul * (fp & fracMask) >> (int)precision);
    }

    public static long round(long fp) {
        boolean neg = false;
        if (fp < 0L) {
            fp = -fp;
            neg = true;
        }
        fp += HALF;
        return neg ? -fp : (fp &= fracMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long min(long fp1, long fp2) {
        return fp2 >= fp1 ? fp1 : fp2;
    }

    public static long max(long fp1, long fp2) {
        return fp1 >= fp2 ? fp1 : fp2;
    }

    public static long abs(long fp) {
        if (fp < 0L) {
            return -fp;
        }
        return fp;
    }

    public static long add(long fp1, long fp2) {
        return fp1 + fp2;
    }

    public static long sub(long fp1, long fp2) {
        return fp1 - fp2;
    }

    public static long IEEERemainder(long fp1, long fp2) {
        return fp1 - MathFP.mul(MathFP.floor(MathFP.div(fp1, fp2)), fp2);
    }

    public static long mul(long fp1, long fp2) {
        long fp = fp1 * fp2;
        return fp >> (int)precision;
    }

    public static long div(long fp1, long fp2) {
        if (fp1 == 0L) {
            return 0L;
        }
        if (fp2 == 0L) {
            return fp1 < 0L ? -2147483647L : Integer.MAX_VALUE;
        }
        long xneg = 0L;
        long yneg = 0L;
        if (fp1 < 0L) {
            xneg = 1L;
            fp1 = -fp1;
        }
        if (fp2 < 0L) {
            yneg = 1L;
            fp2 = -fp2;
        }
        long msb = 0L;
        long lsb = 0L;
        while ((fp1 & (long)(1 << (int)(30L - msb))) == 0L) {
            ++msb;
        }
        while ((fp2 & (long)(1 << (int)lsb)) == 0L) {
            ++lsb;
        }
        long shifty = precision - (msb + lsb);
        long res = (fp1 << (int)msb) / (fp2 >> (int)lsb);
        res = shifty > 0L ? (res <<= (int)shifty) : (res >>= (int)(-shifty));
        if ((xneg ^ yneg) == 1L) {
            res = -res;
        }
        return res;
    }

    public static long sqrt(long fp) {
        long s = fp + ONE >> 1;
        for (int i = 0; i < 8; ++i) {
            s = s + MathFP.div(fp, s) >> 1;
        }
        return s;
    }

    public static long sin(long fp) {
        long sign = 1L;
        if ((fp %= PI * 2L) < 0L) {
            fp = PI * 2L + fp;
        }
        if (fp > PI_HALF && fp <= PI) {
            fp = PI - fp;
        } else if (fp > PI && fp <= PI + PI_HALF) {
            fp -= PI;
            sign = -1L;
        } else if (fp > PI + PI_HALF) {
            fp = (PI << 1) - fp;
            sign = -1L;
        }
        long sqr = MathFP.mul(fp, fp);
        long result = SK[0];
        result = MathFP.mul(result, sqr);
        result -= (long)SK[1];
        result = MathFP.mul(result, sqr);
        result += ONE;
        result = MathFP.mul(result, fp);
        return sign * result;
    }

    public static long cos(long fp) {
        return MathFP.sin(PI_HALF - fp);
    }

    public static long tan(long fp) {
        return MathFP.div(MathFP.sin(fp), MathFP.cos(fp));
    }

    public static long asin(long fp) {
        boolean neg = false;
        if (fp < 0L) {
            neg = true;
            fp = -fp;
        }
        long fRoot = MathFP.sqrt(ONE - fp);
        long result = AS[0];
        result = MathFP.mul(result, fp);
        result += (long)AS[1];
        result = MathFP.mul(result, fp);
        result -= (long)AS[2];
        result = MathFP.mul(result, fp);
        result += (long)AS[3];
        result = PI_HALF - MathFP.mul(fRoot, result);
        if (neg) {
            result = -result;
        }
        return result;
    }

    public static long acos(long fp) {
        return PI_HALF - MathFP.asin(fp);
    }

    public static long atan(long fp) {
        return MathFP.asin(MathFP.div(fp, MathFP.sqrt(ONE + MathFP.mul(fp, fp))));
    }

    public static long atan2(long fpX, long fpY) {
        if (fpX == 0L) {
            if (fpY >= 0L) {
                return 0L;
            }
            if (fpY < 0L) {
                return PI;
            }
        } else if (fpY >= (long)(-ATAN2_ZERO_ERROR) && fpY <= (long)ATAN2_ZERO_ERROR) {
            return fpX > 0L ? PI_HALF : -PI_HALF;
        }
        long z = MathFP.atan(Math.abs(MathFP.div(fpX, fpY)));
        if (fpY > 0L) {
            return fpX > 0L ? z : -z;
        }
        return fpX > 0L ? PI - z : z - PI;
    }

    public static long exp(long fp) {
        if (fp == 0L) {
            return ONE;
        }
        long xabs = Math.abs(fp);
        long k = MathFP.mul(xabs, LN2_INV);
        k += HALF;
        k &= fracMask ^ 0xFFFFFFFFFFFFFFFFL;
        if (fp < 0L) {
            k = -k;
        }
        long z = MathFP.mul(fp -= MathFP.mul(k, LN2), fp);
        long R = TWO + MathFP.mul(z, (long)EXP_P[0] + MathFP.mul(z, (long)EXP_P[1] + MathFP.mul(z, (long)EXP_P[2] + MathFP.mul(z, (long)EXP_P[3] + MathFP.mul(z, EXP_P[4])))));
        long xp = ONE + MathFP.div(MathFP.mul(TWO, fp), R - fp);
        k = k < 0L ? ONE >> (int)(-k >> (int)precision) : ONE << (int)(k >> (int)precision);
        return MathFP.mul(k, xp);
    }

    public static long log(long x) {
        if (x < 0L) {
            return 0L;
        }
        if (x == 0L) {
            return -2147483647L;
        }
        long log2 = 0L;
        long xi = x;
        while (xi >= TWO) {
            xi >>= 1;
            ++log2;
        }
        long f = xi - ONE;
        long s = MathFP.div(f, TWO + f);
        long z = MathFP.mul(s, s);
        long w = MathFP.mul(z, z);
        long R = MathFP.mul(w, (long)LG[1] + MathFP.mul(w, (long)LG[3] + MathFP.mul(w, LG[5]))) + MathFP.mul(z, (long)LG[0] + MathFP.mul(w, (long)LG[2] + MathFP.mul(w, (long)LG[4] + MathFP.mul(w, LG[6]))));
        return MathFP.mul(LN2, log2 << (int)precision) + f - MathFP.mul(s, f - R);
    }

    public static long log(long fp, long base) {
        return MathFP.div(MathFP.log(fp), MathFP.log(base));
    }

    public static long pow(long fp1, long fp2) {
        if (fp2 == 0L) {
            return ONE;
        }
        if (fp1 < 0L) {
            return 0L;
        }
        return MathFP.exp(MathFP.mul(MathFP.log(fp1), fp2));
    }

    public static long toRadians(long fp) {
        return MathFP.mul(fp, piOverOneEighty);
    }

    public static long toDegrees(long fp) {
        return MathFP.mul(fp, oneEightyOverPi);
    }

    static {
        ATAN2_ZERO_ERROR = 65;
        precision = 0L;
        fracMask = 0L;
        SK_VALUE = new int[]{16342350, 356589659};
        SK = new int[SK_VALUE.length];
        AS_VALUE = new int[]{-20110432, 79737141, 227756102, 1686557206};
        AS = new int[AS_VALUE.length];
        LG_VALUE = new int[]{0x55555555, 0x33333333, 613566760, 477218077, 390489238, 328862160, 317788895};
        LG = new int[LG_VALUE.length];
        EXP_P_VALUE = new int[]{0x15555555, -5965232, 142029, -3550, 88};
        EXP_P = new int[EXP_P_VALUE.length];
        MathFP.setPrecision(20);
    }
}

