/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.Line;
import java.util.NoSuchElementException;

class LineIterator
implements IPathIterator {
    Line line;
    AffineTransform affine;
    int index;

    LineIterator(Line l, AffineTransform at) {
        this.line = l;
        this.affine = at;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(int[] coords) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("line iterator out of bounds");
        }
        if (this.index == 0) {
            coords[0] = this.line.x1;
            coords[1] = this.line.y1;
            type = 0;
        } else {
            coords[0] = this.line.x2;
            coords[1] = this.line.y2;
            type = 1;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 1);
        }
        return type;
    }
}

