/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.drawing.geometry.LineIterator;
import com.guidebee.drawing.geometry.MathFP;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.Rectangle;

public class Line
implements IShape {
    public int x1;
    public int y1;
    public int x2;
    public int y2;

    public Line() {
    }

    public Line(int x1, int y1, int x2, int y2) {
        this.setLine(x1, y1, x2, y2);
    }

    public Line(Point p1, Point p2) {
        this.setLine(p1, p2);
    }

    public int getX1() {
        return this.x1;
    }

    public int getY1() {
        return this.y1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public Point getP1() {
        return new Point(this.x1, this.y1);
    }

    public Point getP2() {
        return new Point(this.x2, this.y2);
    }

    public void setLine(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void setLine(Point p1, Point p2) {
        this.setLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void setLine(Line l) {
        this.setLine(l.x1, l.y1, l.x2, l.y2);
    }

    @Override
    public Rectangle getBounds() {
        int h;
        int y;
        int w;
        int x;
        if (this.x1 < this.x2) {
            x = this.x1;
            w = this.x2 - this.x1;
        } else {
            x = this.x2;
            w = this.x1 - this.x2;
        }
        if (this.y1 < this.y2) {
            y = this.y1;
            h = this.y2 - this.y1;
        } else {
            y = this.y2;
            h = this.y1 - this.y2;
        }
        return new Rectangle(x, y, w, h);
    }

    public static int relativeCCW(int x1, int y1, int x2, int y2, int px, int py) {
        int ccw = (px -= x1) * (y2 -= y1) - (py -= y1) * (x2 -= x1);
        if (ccw == 0 && (ccw = px * x2 + py * y2) > 0 && (ccw = (px -= x2) * x2 + (py -= y2) * y2) < 0) {
            ccw = 0;
        }
        return ccw < 0 ? -1 : (ccw > 0 ? 1 : 0);
    }

    public int relativeCCW(int px, int py) {
        return Line.relativeCCW(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public int relativeCCW(Point p) {
        return Line.relativeCCW(this.x1, this.y1, this.x2, this.y2, p.x, p.y);
    }

    public static boolean linesIntersect(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        return Line.relativeCCW(x1, y1, x2, y2, x3, y3) * Line.relativeCCW(x1, y1, x2, y2, x4, y4) <= 0 && Line.relativeCCW(x3, y3, x4, y4, x1, y1) * Line.relativeCCW(x3, y3, x4, y4, x2, y2) <= 0;
    }

    public boolean intersectsLine(int x1, int y1, int x2, int y2) {
        return Line.linesIntersect(x1, y1, x2, y2, this.x1, this.y1, this.x2, this.y2);
    }

    public boolean intersectsLine(Line l) {
        return Line.linesIntersect(l.x1, l.y1, l.x2, l.y2, this.x1, this.y1, this.x2, this.y2);
    }

    public static int ptSegDistSq(int x1, int y1, int x2, int y2, int px, int py) {
        int projlenSq;
        int lenSq;
        int dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if ((lenSq = px * px + py * py - (projlenSq = dotprod <= 0 ? 0 : ((dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2) <= 0 ? 0 : dotprod * dotprod / (x2 * x2 + y2 * y2)))) < 0) {
            lenSq = 0;
        }
        return lenSq;
    }

    public static int ptSegDist(int x1, int y1, int x2, int y2, int px, int py) {
        long dis = Line.ptSegDistSq(x1, y1, x2, y2, px, py);
        return MathFP.toInt(MathFP.sqrt(dis <<= 20));
    }

    public int ptSegDist(int px, int py) {
        return Line.ptSegDist(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public int ptSegDist(Point pt) {
        return Line.ptSegDist(this.x1, this.y1, this.x2, this.y2, pt.x, pt.y);
    }

    public int ptSegDistSq(int px, int py) {
        return Line.ptSegDistSq(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public int ptSegDistSq(Point pt) {
        return Line.ptSegDistSq(this.x1, this.y1, this.x2, this.y2, pt.x, pt.y);
    }

    public static int ptLineDistSq(int x1, int y1, int x2, int y2, int px, int py) {
        int dotprod;
        int projlenSq;
        int lenSq;
        if ((lenSq = (px -= x1) * px + (py -= y1) * py - (projlenSq = (dotprod = px * (x2 -= x1) + py * (y2 -= y1)) * dotprod / (x2 * x2 + y2 * y2))) < 0) {
            lenSq = 0;
        }
        return lenSq;
    }

    public int ptLineDistSq(Point pt) {
        return Line.ptLineDistSq(this.x1, this.y1, this.x2, this.y2, pt.x, pt.y);
    }

    public int ptLineDistSq(int px, int py) {
        return Line.ptLineDistSq(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public static int ptLineDist(int x1, int y1, int x2, int y2, int px, int py) {
        long dis = Line.ptLineDistSq(x1, y1, x2, y2, px, py);
        return MathFP.toInt(MathFP.sqrt(dis <<= 20));
    }

    public int ptLineDist(int px, int py) {
        return Line.ptLineDist(this.x1, this.y1, this.x2, this.y2, px, py);
    }

    public int ptLineDist(Point pt) {
        return Line.ptLineDist(this.x1, this.y1, this.x2, this.y2, pt.x, pt.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    @Override
    public boolean contains(Point p) {
        return false;
    }

    @Override
    public boolean contains(Rectangle r) {
        return false;
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        return false;
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        return this.intersects(new Rectangle(x, y, w, h));
    }

    @Override
    public boolean intersects(Rectangle r) {
        return r.intersectsLine(this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        return new LineIterator(this, at);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at, int flatness) {
        return new LineIterator(this, at);
    }
}

