/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.EllipseIterator;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.drawing.geometry.RectangularShape;

public class Ellipse
extends RectangularShape {
    public double x;
    public double y;
    public double width;
    public double height;

    public Ellipse() {
    }

    public Ellipse(double x, double y, double w, double h) {
        this.setFrame((int)(x + 0.5), (int)(y + 0.5), (int)(w + 0.5), (int)(h + 0.5));
    }

    @Override
    public int getX() {
        return (int)(this.x + 0.5);
    }

    @Override
    public int getY() {
        return (int)(this.y + 0.5);
    }

    @Override
    public int getWidth() {
        return (int)(this.width + 0.5);
    }

    @Override
    public int getHeight() {
        return (int)(this.height + 0.5);
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    @Override
    public void setFrame(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle((int)(this.x + 0.5), (int)(this.y + 0.5), (int)(this.width + 0.5), (int)(this.height + 0.5));
    }

    @Override
    public boolean contains(int x, int y) {
        double ellw = this.getWidth();
        if (ellw <= 0.0) {
            return false;
        }
        double normx = (double)(x - this.getX()) / ellw - 0.5;
        double ellh = this.getHeight();
        if (ellh <= 0.0) {
            return false;
        }
        double normy = (double)(y - this.getY()) / ellh - 0.5;
        return normx * normx + normy * normy < 0.25;
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        if ((double)w <= 0.0 || (double)h <= 0.0) {
            return false;
        }
        double ellw = this.getWidth();
        if (ellw <= 0.0) {
            return false;
        }
        double normx0 = (double)(x - this.getX()) / ellw - 0.5;
        double normx1 = normx0 + (double)w / ellw;
        double ellh = this.getHeight();
        if (ellh <= 0.0) {
            return false;
        }
        double normy0 = (double)(y - this.getY()) / ellh - 0.5;
        double normy1 = normy0 + (double)h / ellh;
        double nearx = normx0 > 0.0 ? normx0 : (normx1 < 0.0 ? normx1 : 0.0);
        double neary = normy0 > 0.0 ? normy0 : (normy1 < 0.0 ? normy1 : 0.0);
        return nearx * nearx + neary * neary < 0.25;
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        return new EllipseIterator(this, at);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        bits += Double.doubleToLongBits(this.getY()) * 37L;
        bits += Double.doubleToLongBits(this.getWidth()) * 43L;
        return (int)(bits += Double.doubleToLongBits(this.getHeight()) * 47L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Ellipse) {
            Ellipse e2d = (Ellipse)obj;
            return this.getX() == e2d.getX() && this.getY() == e2d.getY() && this.getWidth() == e2d.getWidth() && this.getHeight() == e2d.getHeight();
        }
        return false;
    }
}

