/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing;

import com.guidebee.drawing.Brush;
import com.guidebee.drawing.Color;
import com.guidebee.drawing.Utils;
import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.game.engine.drawing.core.RadialGradientBrushFP;
import com.guidebee.game.engine.drawing.core.SingleFP;

public final class RadialGradientBrush
extends Brush {
    private final Point center;
    private final int radius;
    private final int fillType;
    private final AffineTransform gradientTransform;
    private final int[] fractions;
    private final Color[] colors;
    final int transparency;

    public RadialGradientBrush(int cx, int cy, int radius, int[] fractions, Color[] colors) {
        this(new Point(cx, cy), radius, fractions, colors, 0, new AffineTransform());
    }

    public RadialGradientBrush(Point center, int radius, int[] fractions, Color[] colors) {
        this(center, radius, fractions, colors, 0, new AffineTransform());
    }

    public RadialGradientBrush(Point center, int radius, int[] fractions, Color[] colors, int fillType, AffineTransform gradientTransform) {
        int i;
        if (fractions == null) {
            throw new NullPointerException("Fractions array cannot be null");
        }
        if (colors == null) {
            throw new NullPointerException("Colors array cannot be null");
        }
        if (gradientTransform == null) {
            throw new NullPointerException("Gradient transform cannot be null");
        }
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("Colors and fractions must have equal size");
        }
        if (colors.length < 2) {
            throw new IllegalArgumentException("User must specify at least 2 colors");
        }
        int previousFraction = -255;
        for (int i2 = 0; i2 < fractions.length; ++i2) {
            int currentFraction = fractions[i2];
            if (currentFraction < 0 || currentFraction > 255) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 255: " + currentFraction);
            }
            if (currentFraction <= previousFraction) {
                throw new IllegalArgumentException("Keyframe fractions must be increasing: " + currentFraction);
            }
            previousFraction = currentFraction;
        }
        boolean fixFirst = false;
        boolean fixLast = false;
        int len = fractions.length;
        int off = 0;
        if (fractions[0] != 0) {
            fixFirst = true;
            ++len;
            ++off;
        }
        if (fractions[fractions.length - 1] != 255) {
            fixLast = true;
            ++len;
        }
        this.fractions = new int[len];
        System.arraycopy(fractions, 0, this.fractions, off, fractions.length);
        this.colors = new Color[len];
        System.arraycopy(colors, 0, this.colors, off, colors.length);
        if (fixFirst) {
            this.fractions[0] = 0;
            this.colors[0] = colors[0];
        }
        if (fixLast) {
            this.fractions[len - 1] = 255;
            this.colors[len - 1] = colors[colors.length - 1];
        }
        this.gradientTransform = new AffineTransform(gradientTransform);
        boolean opaque = true;
        for (i = 0; i < colors.length; ++i) {
            opaque = opaque && colors[i].getAlpha() == 255;
        }
        int n = this.transparency = opaque ? 1 : 3;
        if (center == null) {
            throw new NullPointerException("Center point must be non-null");
        }
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be greater than zero");
        }
        this.center = new Point(center.x, center.y);
        this.radius = radius;
        this.fillType = fillType;
        this.wrappedBrushFP = new RadialGradientBrushFP(SingleFP.fromInt(center.x), SingleFP.fromInt(center.y), SingleFP.fromInt(radius), 0);
        for (i = 0; i < colors.length; ++i) {
            ((RadialGradientBrushFP)this.wrappedBrushFP).setGradientColor(SingleFP.fromFloat((float)fractions[i] / 100.0f), colors[i].value);
        }
        ((RadialGradientBrushFP)this.wrappedBrushFP).updateGradientTable();
        this.wrappedBrushFP.setMatrix(Utils.toMatrixFP(gradientTransform));
        this.wrappedBrushFP.fillMode = fillType;
    }

    public Point getCenterPoint() {
        return new Point(this.center.x, this.center.y);
    }

    public int getRadius() {
        return this.radius;
    }

    public int getFillType() {
        return this.fillType;
    }

    public final AffineTransform getTransform() {
        return this.gradientTransform;
    }

    public final int[] getFractions() {
        return this.fractions;
    }

    public final Color[] getColors() {
        return this.colors;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }
}

