/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.utils;

import com.guidebee.game.GameEngine;
import com.guidebee.game.graphics.Pixmap;
import com.guidebee.game.graphics.Texture;
import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.math.MathUtils;
import com.guidebee.utils.collections.BufferUtils;
import java.nio.ByteBuffer;

public final class ScreenUtils {
    public static TextureRegion getFrameBufferTexture() {
        int w = GameEngine.graphics.getWidth();
        int h = GameEngine.graphics.getHeight();
        return ScreenUtils.getFrameBufferTexture(0, 0, w, h);
    }

    public static TextureRegion getFrameBufferTexture(int x, int y, int w, int h) {
        int potW = MathUtils.nextPowerOfTwo(w);
        int potH = MathUtils.nextPowerOfTwo(h);
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(x, y, w, h);
        Pixmap potPixmap = new Pixmap(potW, potH, Pixmap.Format.RGBA8888);
        potPixmap.drawPixmap(pixmap, 0, 0);
        Texture texture = new Texture(potPixmap);
        TextureRegion textureRegion = new TextureRegion(texture, 0, h, w, -h);
        pixmap.dispose();
        return textureRegion;
    }

    public static Pixmap getFrameBufferPixmap(int x, int y, int w, int h) {
        GameEngine.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        ByteBuffer pixels = pixmap.getPixels();
        GameEngine.gl.glReadPixels(x, y, w, h, 6408, 5121, pixels);
        return pixmap;
    }

    public static byte[] getFrameBufferPixels(boolean flipY) {
        int w = GameEngine.graphics.getWidth();
        int h = GameEngine.graphics.getHeight();
        return ScreenUtils.getFrameBufferPixels(0, 0, w, h, flipY);
    }

    public static byte[] getFrameBufferPixels(int x, int y, int w, int h, boolean flipY) {
        GameEngine.gl.glPixelStorei(3333, 1);
        ByteBuffer pixels = BufferUtils.newByteBuffer(w * h * 4);
        GameEngine.gl.glReadPixels(x, y, w, h, 6408, 5121, pixels);
        int numBytes = w * h * 4;
        byte[] lines = new byte[numBytes];
        if (flipY) {
            int numBytesPerLine = w * 4;
            for (int i = 0; i < h; ++i) {
                pixels.position((h - i - 1) * numBytesPerLine);
                pixels.get(lines, i * numBytesPerLine, numBytesPerLine);
            }
        } else {
            pixels.clear();
            pixels.get(lines);
        }
        return lines;
    }
}

