/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.utils;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public class DataReader {
    public static boolean isJava = true;

    public static double readDouble(DataInput in) throws IOException {
        double ret = 0.0;
        if (!isJava) {
            byte[] buffer = new byte[8];
            for (int i = 0; i < 8; ++i) {
                buffer[7 - i] = in.readByte();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            DataInputStream dis = new DataInputStream(bais);
            ret = dis.readDouble();
            dis.close();
            bais.close();
        } else {
            ret = in.readDouble();
        }
        return ret;
    }

    public static long readLong(DataInput in) throws IOException {
        long ret = 0L;
        if (!isJava) {
            byte[] buffer = new byte[8];
            for (int i = 0; i < 8; ++i) {
                buffer[7 - i] = in.readByte();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            DataInputStream dis = new DataInputStream(bais);
            ret = dis.readLong();
            dis.close();
            bais.close();
        } else {
            ret = in.readLong();
        }
        return ret;
    }

    public static int readInt(DataInput in) throws IOException {
        int ret = 0;
        if (!isJava) {
            byte[] buffer = new byte[4];
            for (int i = 0; i < 4; ++i) {
                buffer[3 - i] = in.readByte();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            DataInputStream dis = new DataInputStream(bais);
            ret = dis.readInt();
            dis.close();
            bais.close();
        } else {
            ret = in.readInt();
        }
        return ret;
    }

    public static short readShort(DataInput in) throws IOException {
        short ret = 0;
        if (!isJava) {
            byte[] buffer = new byte[2];
            for (int i = 0; i < 2; ++i) {
                buffer[1 - i] = in.readByte();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            DataInputStream dis = new DataInputStream(bais);
            ret = dis.readShort();
            dis.close();
            bais.close();
        } else {
            ret = in.readShort();
        }
        return ret;
    }

    public static String readString(DataInput in) throws IOException {
        String retStr = "";
        if (!isJava) {
            int len = in.readUnsignedByte();
            byte[] buffer = new byte[len + 2];
            buffer[0] = 0;
            buffer[1] = (byte)len;
            for (int i = 0; i < len; ++i) {
                buffer[i + 2] = in.readByte();
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
            DataInputStream dis = new DataInputStream(bis);
            retStr = dis.readUTF();
            bis.close();
            dis.close();
        } else {
            retStr = in.readUTF();
        }
        return retStr;
    }

    public static void seek(DataInputStream in, long offset) throws IOException {
        long total = offset;
        in.reset();
        long skipped = in.skip(offset);
        long remain = total - skipped;
        while (remain > 0L) {
            total = remain;
            skipped = in.skip(total);
            remain = total - skipped;
        }
    }
}

