/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.math;

import java.util.Date;
import java.util.Vector;

public class Utils {
    private static String[][] url_encode_map = new String[][]{{" ", "%20"}, {"!", "%21"}, {"\"", "%22"}, {"#", "%23"}, {"$", "%24"}, {"%", "%25"}, {"&", "%26"}, {"'", "%27"}, {"(", "%28"}, {")", "%29"}, {"*", "%2A"}, {"+", "%2B"}, {",", "%2C"}, {"-", "%2D"}, {".", "%2E"}, {"/", "%2F"}, {"0", "%30"}, {"1", "%31"}, {"2", "%32"}, {"3", "%33"}, {"4", "%34"}, {"5", "%35"}, {"6", "%36"}, {"7", "%37"}, {"8", "%38"}, {"9", "%39"}, {":", "%3A"}, {";", "%3B"}, {"<", "%3C"}, {"=", "%3D"}, {">", "%3E"}, {"?", "%3F"}, {"@", "%40"}, {"A", "%41"}, {"B", "%42"}, {"C", "%43"}, {"D", "%44"}, {"E", "%45"}, {"F", "%46"}, {"G", "%47"}, {"H", "%48"}, {"I", "%49"}, {"J", "%4A"}, {"K", "%4B"}, {"L", "%4C"}, {"M", "%4D"}, {"N", "%4E"}, {"O", "%4F"}, {"P", "%50"}, {"Q", "%51"}, {"R", "%52"}, {"S", "%53"}, {"T", "%54"}, {"U", "%55"}, {"V", "%56"}, {"W", "%57"}, {"X", "%58"}, {"Y", "%59"}, {"Z", "%5A"}, {"[", "%5B"}, {"\\", "%5C"}, {"]", "%5D"}, {"^", "%5E"}, {"_", "%5F"}, {"`", "%60"}, {"a", "%61"}, {"b", "%62"}, {"c", "%63"}, {"d", "%64"}, {"e", "%65"}, {"f", "%66"}, {"g", "%67"}, {"h", "%68"}, {"i", "%69"}, {"j", "%6A"}, {"k", "%6B"}, {"l", "%6C"}, {"m", "%6D"}, {"n", "%6E"}, {"o", "%6F"}, {"p", "%70"}, {"q", "%71"}, {"r", "%72"}, {"s", "%73"}, {"t", "%74"}, {"u", "%75"}, {"v", "%76"}, {"w", "%77"}, {"x", "%78"}, {"y", "%79"}, {"z", "%7A"}, {"{", "%7B"}, {"|", "%7C"}, {"}", "%7D"}, {"~", "%7E"}};
    private static String[][] url_encode_map_unsafe = new String[][]{{" ", "%20"}, {"!", "%21"}, {"\"", "%22"}, {"#", "%23"}, {"$", "%24"}, {"%", "%25"}, {"&", "%26"}, {"'", "%27"}, {"(", "%28"}, {")", "%29"}, {"*", "%2A"}, {"+", "%2B"}, {",", "%2C"}, {"/", "%2F"}, {":", "%3A"}, {";", "%3B"}, {"<", "%3C"}, {"=", "%3D"}, {">", "%3E"}, {"?", "%3F"}, {"@", "%40"}, {"[", "%5B"}, {"\\", "%5C"}, {"]", "%5D"}, {"^", "%5E"}, {"`", "%60"}, {"{", "%7B"}, {"|", "%7C"}, {"}", "%7D"}, {"~", "%7E"}};
    private static int _fromIndex = 0;

    public static byte[] shortToBytes(short l, boolean bigendian) {
        byte[] by = new byte[2];
        if (bigendian) {
            by[0] = (byte)(l >> 8);
            by[1] = (byte)(l & 0xFF);
        } else {
            by[0] = (byte)(l & 0xFF);
            by[1] = (byte)(l >> 8);
        }
        return by;
    }

    public static byte[] intToBytes(int l, boolean bigendian) {
        byte[] b = new byte[4];
        if (bigendian) {
            b[0] = (byte)(l >> 24);
            b[1] = (byte)(l >> 16);
            b[2] = (byte)(l >> 8);
            b[3] = (byte)(l & 0xFF);
        } else {
            b[0] = (byte)(l & 0xFF);
            b[1] = (byte)(l >> 8);
            b[2] = (byte)(l >> 16);
            b[3] = (byte)(l >> 24);
        }
        return b;
    }

    public static byte[] longToBytes(long l, boolean bigendian) {
        byte[] b = new byte[8];
        if (bigendian) {
            b[0] = (byte)(l >> 56);
            b[1] = (byte)(l >> 48);
            b[2] = (byte)(l >> 40);
            b[3] = (byte)(l >> 32);
            b[4] = (byte)(l >> 24);
            b[5] = (byte)(l >> 16);
            b[6] = (byte)(l >> 8);
            b[7] = (byte)(l & 0xFFL);
        } else {
            b[0] = (byte)(l & 0xFFL);
            b[1] = (byte)(l >> 8);
            b[2] = (byte)(l >> 16);
            b[3] = (byte)(l >> 24);
            b[4] = (byte)(l >> 32);
            b[5] = (byte)(l >> 40);
            b[6] = (byte)(l >> 48);
            b[7] = (byte)(l >> 54);
        }
        return b;
    }

    public static short bytesToShort(byte[] by, boolean bigendian) {
        short s = 0;
        s = bigendian ? (short)(by[0] << 8 | 0xFF & by[1]) : (short)(by[1] << 8 | 0xFF & by[0]);
        return s;
    }

    public static int bytesToUShort(byte[] by, boolean bigendian) {
        int i = 0;
        i = by.length == 1 ? 0xFF & by[0] : (bigendian ? (by[0] & 0xFF) << 8 | 0xFF & by[1] : (by[1] & 0xFF) << 8 | 0xFF & by[0]);
        return i;
    }

    public static int bytesToInt(byte[] b, boolean bigendian) {
        int i = 0;
        i = b.length == 1 ? 0xFF & b[0] : (b.length == 2 ? (bigendian ? (b[0] & 0xFF) << 8 | 0xFF & b[1] : (b[1] & 0xFF) << 8 | 0xFF & b[1]) : (b.length == 3 ? (bigendian ? ((b[0] & 0xFF) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[2] : ((b[2] & 0xFF) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[0]) : (bigendian ? (((b[0] & 0xFF) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[3] : (((b[3] & 0xFF) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[0])));
        return i;
    }

    public static long bytesToLong(byte[] b, boolean bigendian) {
        int i = 0;
        if (b.length == 1) {
            i = 0xFF & b[0];
        } else if (b.length == 2) {
            i = bigendian ? (b[0] & 0xFF) << 8 | 0xFF & b[1] : (b[1] & 0xFF) << 8 | 0xFF & b[1];
        } else if (b.length == 3) {
            i = bigendian ? ((b[0] & 0xFF) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[2] : ((b[2] & 0xFF) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[0];
        } else if (b.length == 4) {
            i = bigendian ? (((b[0] & 0xFF) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[3] : (((b[3] & 0xFF) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[0];
        } else if (b.length == 5) {
            i = bigendian ? ((((b[0] & 0xFF) << 8 | b[1] & 0xFF) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[3]) << 8 | 0xFF & b[4] : ((((b[4] & 0xFF) << 8 | b[3] & 0xFF) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[0];
        } else if (b.length == 6) {
            i = bigendian ? (((((b[0] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[2] & 0xFF) << 8 | 0xFF & b[3]) << 8 | 0xFF & b[4]) << 8 | 0xFF & b[5] : (((((b[5] & 0xFF) << 8 | b[4] & 0xFF) << 8 | b[3] & 0xFF) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[0];
        } else if (b.length == 7) {
            i = bigendian ? ((((((b[0] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[2] & 0xFF) << 8 | b[3] & 0xFF) << 8 | 0xFF & b[4]) << 8 | 0xFF & b[5]) << 8 | 0xFF & b[6] : (((((b[6] & 0xFF) << 8 | (b[5] & 0xFF) << 8 | b[4] & 0xFF) << 8 | b[3] & 0xFF) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[0];
        } else if (b.length == 8) {
            i = bigendian ? (((((((b[0] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[2] & 0xFF) << 8 | b[3] & 0xFF) << 8 | b[4] & 0xFF) << 8 | 0xFF & b[5]) << 8 | 0xFF & b[6]) << 8 | 0xFF & b[7] : ((((((b[7] & 0xFF) << 8 | b[6] & 0xFF) << 8 | (b[5] & 0xFF) << 8 | b[4] & 0xFF) << 8 | b[3] & 0xFF) << 8 | 0xFF & b[2]) << 8 | 0xFF & b[1]) << 8 | 0xFF & b[0];
        }
        return i;
    }

    public int hexToInt(String s) {
        int[] n = new int[s.length()];
        int sum = 0;
        int koef = 1;
        for (int i = n.length - 1; i >= 0; --i) {
            char c = s.charAt(i);
            switch (c) {
                case '0': {
                    n[i] = 0;
                    break;
                }
                case '1': {
                    n[i] = 1;
                    break;
                }
                case '2': {
                    n[i] = 2;
                    break;
                }
                case '3': {
                    n[i] = 3;
                    break;
                }
                case '4': {
                    n[i] = 4;
                    break;
                }
                case '5': {
                    n[i] = 5;
                    break;
                }
                case '6': {
                    n[i] = 6;
                    break;
                }
                case '7': {
                    n[i] = 7;
                    break;
                }
                case '8': {
                    n[i] = 8;
                    break;
                }
                case '9': {
                    n[i] = 9;
                    break;
                }
                case 'a': {
                    n[i] = 10;
                    break;
                }
                case 'b': {
                    n[i] = 11;
                    break;
                }
                case 'c': {
                    n[i] = 12;
                    break;
                }
                case 'd': {
                    n[i] = 13;
                    break;
                }
                case 'e': {
                    n[i] = 14;
                    break;
                }
                case 'f': {
                    n[i] = 15;
                }
            }
            sum += n[i] * koef;
            koef *= 16;
        }
        return sum;
    }

    public static short unsignShort(int s) {
        short b = (short)s;
        s = b;
        b = (short)(0 - (s += 32768));
        return b;
    }

    public static String byteArrayToHexString(byte[] in) {
        int j;
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        byte[] chars = new byte[in.length];
        for (j = 0; j < in.length; ++j) {
            chars[j] = in[j] < 33 || in[j] > 126 ? 46 : in[j];
        }
        while (i < in.length) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            ++i;
        }
        for (j = 2; j < in.length * 3; j += 2) {
            out.insert(j, ' ');
            ++j;
        }
        for (j = 24; j < in.length * 3 / 24 + in.length * 3; j += 24) {
            out.insert(j, ' ');
            ++j;
        }
        for (j = 50; j < in.length * 3 / 50 + in.length * 3 / 24 + in.length * 3; j += 50) {
            out.insert(j, '\n');
            ++j;
        }
        String txt = new String(chars);
        String r = new String(out);
        int ind1 = 0;
        int ind2 = 50;
        int at1 = 0;
        int at2 = 16;
        StringBuffer sb = new StringBuffer();
        for (int j2 = 0; j2 < out.length() / 51; ++j2) {
            sb.append(r.substring(ind1, ind2) + "   " + txt.substring(at1, at2) + "\n");
            ind1 = ind2 + 1;
            ind2 += 51;
            at1 += 16;
            at2 += 16;
        }
        ind2 = r.length();
        at2 = txt.length();
        String remains = r.substring(ind1, ind2);
        sb.append(remains);
        for (int j3 = 0; j3 < 53 - remains.length(); ++j3) {
            sb.append(" ");
        }
        sb.append(txt.substring(at1, at2) + "\n");
        out = null;
        String rslt = new String(sb);
        return rslt;
    }

    public static String[] explode(char separator, String str) {
        Vector<String> exploded = new Vector<String>(0, 1);
        String tmpstr = null;
        int beginIndex = 0;
        int endIndex = 0;
        while (endIndex < str.length()) {
            if (str.charAt(endIndex) == separator) {
                if (endIndex > beginIndex) {
                    tmpstr = str.substring(beginIndex, endIndex);
                    exploded.addElement(tmpstr);
                    beginIndex = ++endIndex;
                    tmpstr = null;
                    continue;
                }
                exploded.addElement(null);
                beginIndex = ++endIndex;
                continue;
            }
            ++endIndex;
        }
        if (endIndex > beginIndex) {
            tmpstr = str.substring(beginIndex, endIndex);
            exploded.addElement(tmpstr);
        }
        Object[] res = new String[exploded.size()];
        exploded.copyInto(res);
        return res;
    }

    public static String replace(String[] pattern, String[] replace, String source) {
        String result = "";
        if (pattern.length != replace.length) {
            return source;
        }
        result = source;
        for (int i = 0; i < pattern.length; ++i) {
            result = Utils.replace(pattern[i], replace[i], result);
        }
        return result;
    }

    public static String replace(String pattern, String replace, String source) {
        String result = "";
        int firstIndex = 0;
        while (source.indexOf(pattern, firstIndex) != -1) {
            result = result + source.substring(firstIndex, source.indexOf(pattern, firstIndex));
            result = result + replace;
            firstIndex = source.indexOf(pattern, firstIndex) + pattern.length();
        }
        if (firstIndex < source.length()) {
            result = result + source.substring(firstIndex);
        }
        return result;
    }

    public static String urlEncode(String s) {
        String[] patterns = new String[url_encode_map_unsafe.length];
        String[] replaces = new String[url_encode_map_unsafe.length];
        for (int i = 0; i < url_encode_map_unsafe.length; ++i) {
            patterns[i] = url_encode_map_unsafe[i][0];
            replaces[i] = url_encode_map_unsafe[i][1];
        }
        String res = Utils.replace(patterns, replaces, s);
        return res;
    }

    public static String urlDecode(String s) {
        String[] patterns = new String[url_encode_map.length];
        String[] replaces = new String[url_encode_map.length];
        for (int i = 0; i < url_encode_map.length; ++i) {
            patterns[i] = url_encode_map[i][1];
            replaces[i] = url_encode_map[i][0];
        }
        String res = Utils.replace(patterns, replaces, s);
        return res;
    }

    public static String getStringForTag(String Tag, String strTmp) {
        return Utils.getStringForTag(Tag, strTmp, true);
    }

    public static String getStringForTag(String Tag, String strTmp, boolean newSearch) {
        String untaggedString = null;
        String beginTag = "<" + Tag + ">";
        String endTag = "</" + Tag + ">";
        if (newSearch) {
            _fromIndex = 0;
        }
        if (strTmp != null) {
            int tag1 = strTmp.indexOf(beginTag, _fromIndex);
            int tag2 = strTmp.indexOf(endTag, _fromIndex);
            if (tag1 != -1 && tag2 != -1) {
                untaggedString = strTmp.substring(tag1 += beginTag.length(), tag2);
                _fromIndex = tag2 + endTag.length();
            }
        }
        return untaggedString;
    }

    public static String getStringBetweenTags(String Tag, String ClosingTag, String strTmp) {
        String untaggedString = null;
        String beginTag = Tag;
        String endTag = ClosingTag;
        if (strTmp != null) {
            int tag1 = strTmp.indexOf(beginTag, 0);
            int tag2 = strTmp.indexOf(endTag, tag1);
            if (tag1 != -1 && tag2 != -1) {
                untaggedString = strTmp.substring(tag1 += beginTag.length(), tag2);
                _fromIndex = tag2 + endTag.length();
            }
        }
        return untaggedString;
    }

    public static boolean stringContains(String s, String seq) {
        return s.indexOf(seq) >= 0;
    }

    public static String[] splitString(String in, char ch) {
        String[] result = new String[2];
        int pos = in.indexOf(ch);
        if (pos != -1) {
            result[0] = in.substring(0, pos).trim();
            result[1] = in.substring(pos + 1).trim();
        } else {
            result[0] = in.trim();
        }
        return result;
    }

    public static String getCurrentTimestamp() {
        return Utils.formatDate(new Date());
    }

    public static String formatDate(Date d) {
        return "";
    }

    private static String padInt(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    public static byte[] subArray(byte[] b, int off, int len) {
        byte[] sub = new byte[len];
        System.arraycopy(b, off, sub, 0, len);
        return sub;
    }

    public static final boolean compareByteArray(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static String[] tokenize(String s) {
        return Utils.tokenize(s, ' ');
    }

    public static String[] tokenize(String s, char delimiter) {
        Vector<String> v = new Vector<String>();
        int i = s.indexOf(delimiter);
        int currentIndex = -1;
        while (i != -1) {
            v.addElement(new String(s.substring(currentIndex + 1, i)));
            currentIndex = i;
            i = s.indexOf(delimiter, i + 1);
        }
        v.addElement(new String(s.substring(currentIndex + 1)));
        Object[] returnArray = new String[v.size()];
        v.copyInto(returnArray);
        return returnArray;
    }
}

