/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.GameEngine;
import com.guidebee.game.InputProcessor;
import com.guidebee.game.ScreenAdapter;
import com.guidebee.game.camera.viewports.ScalingViewport;
import com.guidebee.game.camera.viewports.ScreenViewport;
import com.guidebee.game.engine.scene.Stage;
import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.SpriteBatch;
import com.guidebee.game.ui.Table;
import com.guidebee.game.ui.Widget;
import com.guidebee.game.ui.WidgetGroup;

public class Window
extends ScreenAdapter {
    private SpriteBatch batch;
    private Stage stage;
    private Table table = new Table();
    private InputProcessor savedInputProcessor = null;

    public void addComponent(Widget actor) {
        this.table.addActor(actor);
    }

    public void addComponent(WidgetGroup actor) {
        this.table.addActor(actor);
    }

    public Window(int width, int height) {
        this.stage = new Stage(new ScalingViewport(width, height));
        this.table.setFillParent(true);
        this.stage.addActor(this.table);
        this.batch = new SpriteBatch();
    }

    public Window() {
        this.stage = new Stage(new ScreenViewport());
        this.batch = new SpriteBatch();
    }

    @Override
    public void show() {
        this.savedInputProcessor = GameEngine.input.getInputProcessor();
        GameEngine.input.setInputProcessor(this.stage);
    }

    @Override
    public void hide() {
        GameEngine.input.setInputProcessor(this.savedInputProcessor);
    }

    public Batch getBatch() {
        return this.stage.getBatch();
    }

    public float getWidth() {
        return this.stage.getWidth();
    }

    public float getHeight() {
        return this.stage.getHeight();
    }

    @Override
    public void render(float delta) {
        GameEngine.graphics.clearScreen(0.0f, 0.0f, 0.0f, 1.0f);
        this.batch.begin();
        this.stage.draw();
        this.batch.end();
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.stage.dispose();
    }
}

