/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.scene.actions;

import com.guidebee.game.engine.scene.Actor;
import com.guidebee.game.engine.utils.reflect.ClassReflection;
import com.guidebee.game.scene.actions.Action;
import com.guidebee.game.ui.Event;
import com.guidebee.game.ui.EventListener;

public abstract class EventAction<T extends Event>
extends Action {
    final Class<? extends T> eventClass;
    boolean result;
    boolean active;
    private final EventListener listener = new EventListener(){

        @Override
        public boolean handle(Event event) {
            if (!EventAction.this.active || !ClassReflection.isInstance(EventAction.this.eventClass, event)) {
                return false;
            }
            EventAction.this.result = EventAction.this.handle(event);
            return EventAction.this.result;
        }
    };

    public EventAction(Class<? extends T> eventClass) {
        this.eventClass = eventClass;
    }

    @Override
    public void restart() {
        this.result = false;
        this.active = false;
    }

    @Override
    public void setActor(Actor actor) {
        if (this.getActor() != null) {
            this.getActor().removeListener(this.listener);
        }
        super.setActor(actor);
        if (actor != null) {
            actor.addListener(this.listener);
        }
    }

    public abstract boolean handle(T var1);

    @Override
    public boolean act(float delta) {
        this.active = true;
        return this.result;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

