/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.scene.actions;

import com.guidebee.game.engine.scene.Actor;
import com.guidebee.game.scene.actions.Action;
import com.guidebee.game.scene.actions.DelegateAction;
import com.guidebee.utils.collections.Array;

public class AfterAction
extends DelegateAction {
    private Array<Action> waitForActions = new Array(false, 4);

    @Override
    public void setActor(Actor actor) {
        if (actor != null) {
            this.waitForActions.addAll(actor.getActions());
        }
        super.setActor(actor);
    }

    @Override
    public void restart() {
        super.restart();
        this.waitForActions.clear();
    }

    @Override
    protected boolean delegate(float delta) {
        Array<Action> currentActions = this.actor.getActions();
        if (currentActions.size == 1) {
            this.waitForActions.clear();
        }
        for (int i = this.waitForActions.size - 1; i >= 0; --i) {
            Action action = this.waitForActions.get(i);
            int index = currentActions.indexOf(action, true);
            if (index != -1) continue;
            this.waitForActions.removeIndex(i);
        }
        if (this.waitForActions.size > 0) {
            return false;
        }
        return this.action.act(delta);
    }
}

