/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.physics.joints;

import com.guidebee.game.physics.Body;
import com.guidebee.game.physics.JointDef;
import com.guidebee.math.Vector2;

public class PulleyJointDef
extends JointDef {
    private static final float minPulleyLength = 2.0f;
    public final Vector2 groundAnchorA = new Vector2(-1.0f, 1.0f);
    public final Vector2 groundAnchorB = new Vector2(1.0f, 1.0f);
    public final Vector2 localAnchorA = new Vector2(-1.0f, 0.0f);
    public final Vector2 localAnchorB = new Vector2(1.0f, 0.0f);
    public float lengthA = 0.0f;
    public float lengthB = 0.0f;
    public float ratio = 1.0f;

    public PulleyJointDef() {
        this.type = JointDef.JointType.PulleyJoint;
        this.collideConnected = true;
    }

    public void initialize(Body bodyA, Body bodyB, Vector2 groundAnchorA, Vector2 groundAnchorB, Vector2 anchorA, Vector2 anchorB, float ratio) {
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.groundAnchorA.set(groundAnchorA);
        this.groundAnchorB.set(groundAnchorB);
        this.localAnchorA.set(bodyA.getLocalPoint(anchorA));
        this.localAnchorB.set(bodyB.getLocalPoint(anchorB));
        this.lengthA = anchorA.dst(groundAnchorA);
        this.lengthB = anchorB.dst(groundAnchorB);
        this.ratio = ratio;
        float C = this.lengthA + ratio * this.lengthB;
    }
}

