/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.microedition;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.Texture;
import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.game.microedition.Layer;
import com.guidebee.game.microedition.TiledLayer;
import com.guidebee.math.geometry.Rectangle;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private int frame;
    private int[] sequence;
    private int cols;
    private int rows;
    private int transform;
    private TextureRegion img;
    private int collX;
    private int collY;
    private int collWidth;
    private int collHeight;
    Rectangle srcRect = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
    Rectangle dstRect = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
    private final TextureRegion[][] tilesTextRegions;

    public Sprite(Texture img) {
        this(new TextureRegion(img));
    }

    public Sprite(TextureRegion img) {
        this(img, img.getRegionWidth(), img.getRegionHeight());
    }

    public Sprite(Texture img, int frameWidth, int frameHeight) {
        this(new TextureRegion(img), frameWidth, frameHeight);
    }

    public Sprite(TextureRegion img, int frameWidth, int frameHeight) {
        super(0.0f, 0.0f, frameWidth, frameHeight, true);
        if (img.getRegionWidth() % frameWidth != 0 || img.getRegionHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.img = img;
        this.cols = img.getRegionWidth() / frameWidth;
        this.rows = img.getRegionHeight() / frameHeight;
        this.collY = 0;
        this.collX = 0;
        this.collWidth = frameWidth;
        this.collHeight = frameHeight;
        this.tilesTextRegions = img.split(frameWidth, frameHeight);
    }

    public Sprite(Sprite otherSprite) {
        super(otherSprite.getX(), otherSprite.getY(), otherSprite.getWidth(), otherSprite.getHeight(), otherSprite.isVisible());
        this.frame = otherSprite.frame;
        this.sequence = otherSprite.sequence;
        this.cols = otherSprite.cols;
        this.rows = otherSprite.rows;
        this.transform = otherSprite.transform;
        this.img = otherSprite.img;
        this.collX = otherSprite.collX;
        this.collY = otherSprite.collY;
        this.collWidth = otherSprite.collWidth;
        this.collHeight = otherSprite.collHeight;
        this.tilesTextRegions = this.img.split((int)this.getWidth(), (int)this.getHeight());
    }

    public final boolean collidesWith(TextureRegion image, int iX, int iY) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.collidesWith(image, iX, iY);
    }

    public final boolean collidesWith(TiledLayer layer) {
        if (layer == null) {
            throw new NullPointerException();
        }
        if (!this.isVisible()) {
            return false;
        }
        if (!layer.isVisible() || !this.isVisible()) {
            return false;
        }
        return this.collidesWith(layer, 0, 0);
    }

    public final boolean collidesWith(Sprite otherSprite) {
        if (otherSprite == null) {
            throw new NullPointerException();
        }
        if (!otherSprite.isVisible() || !this.isVisible()) {
            return false;
        }
        return this.collidesWith(otherSprite, 0, 0);
    }

    public void defineCollisionRectangle(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.collX = x;
        this.collY = y;
        this.collWidth = width;
        this.collHeight = height;
    }

    public void setFrameSequence(int[] sequence) {
        if (sequence == null) {
            this.sequence = null;
            return;
        }
        int max = this.rows * this.cols - 1;
        int l = sequence.length;
        if (l == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < l; ++i) {
            int value = sequence[i];
            if (value <= max && value >= 0) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.sequence = sequence;
        this.frame = 0;
    }

    public final int getFrame() {
        return this.frame;
    }

    public int getFrameSequenceLength() {
        return this.sequence == null ? this.rows * this.cols : this.sequence.length;
    }

    public void setFrame(int frame) {
        int l;
        int n = l = this.sequence == null ? this.rows * this.cols : this.sequence.length;
        if (frame < 0 || frame >= l) {
            throw new IndexOutOfBoundsException();
        }
        this.frame = frame;
    }

    public void nextFrame() {
        this.frame = this.frame == (this.sequence == null ? this.rows * this.cols : this.sequence.length) - 1 ? 0 : ++this.frame;
    }

    public void prevFrame() {
        this.frame = this.frame == 0 ? (this.sequence == null ? this.rows * this.cols : this.sequence.length) - 1 : --this.frame;
    }

    @Override
    public final void paint(Batch g) {
        if (!this.isVisible()) {
            return;
        }
        int f = this.sequence == null ? this.frame : this.sequence[this.frame];
        int w = (int)this.getWidth();
        int h = (int)this.getHeight();
        int fx = w * (f % this.cols);
        int fy = h * (f / this.cols);
        this.srcRect.x = fx;
        this.srcRect.y = fy;
        this.srcRect.width = w;
        this.srcRect.height = h;
        this.dstRect.x = this.getX();
        this.dstRect.y = this.getY();
        this.dstRect.width = w;
        this.dstRect.height = h;
        float rotation = 0.0f;
        boolean flipX = false;
        boolean flipY = false;
        float originX = 0.0f;
        float originY = 0.0f;
        switch (this.transform) {
            case 0: {
                break;
            }
            case 1: {
                flipY = true;
                break;
            }
            case 2: {
                flipX = true;
                break;
            }
            case 3: {
                rotation = 180.0f;
                originY = this.getOriginY();
                originX = this.getOriginX();
                break;
            }
            case 4: {
                rotation = 90.0f;
                originY = this.getOriginY();
                originX = this.getOriginX();
                flipX = true;
                break;
            }
            case 5: {
                rotation = 270.0f;
                originY = this.getOriginY();
                originX = this.getOriginX();
                break;
            }
            case 6: {
                rotation = 90.0f;
                originY = this.getOriginY();
                originX = this.getOriginX();
                break;
            }
            case 7: {
                rotation = 270.0f;
                originY = this.getOriginY();
                originX = this.getOriginX();
                flipX = true;
            }
        }
        this.setRotation(rotation);
        int xIndex = f % this.cols;
        int yIndex = f / this.cols;
        TextureRegion newRegion = this.tilesTextRegions[yIndex][xIndex];
        g.draw(newRegion, this.dstRect.x, this.dstRect.y, originX, originY, this.dstRect.width, this.dstRect.height, 1.0f, 1.0f, rotation, flipX, flipY);
    }

    public int getRawFrameCount() {
        return this.cols * this.rows;
    }

    public void setTransform(int transform) {
        if (this.transform == transform) {
            return;
        }
        this.transform = transform;
    }

    private synchronized boolean collidesWith(Object o, int oX, int oY) {
        int tX = 0;
        int tY = 0;
        int tW = 0;
        int tH = 0;
        int oW = 0;
        int oH = 0;
        Sprite t = this;
        boolean another = true;
        while (another) {
            int sH;
            int sW;
            int sY;
            int sX;
            int cX = t.collX;
            int cY = t.collY;
            int cW = t.collWidth;
            int cH = t.collHeight;
            if (cW == 0 || cH == 0) {
                return false;
            }
            switch (t.transform) {
                case 0: {
                    sX = (int)(t.getX() + (float)cX);
                    sY = (int)(t.getY() + (float)cY);
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 1: {
                    sX = (int)(t.getX() + (float)cX);
                    sY = (int)(t.getY() + (t.getHeight() - (float)cY - 1.0f) - (float)cH);
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 2: {
                    sX = (int)(t.getX() + (t.getWidth() - (float)cX - 1.0f) - (float)cW);
                    sY = (int)(t.getY() + (float)cY);
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 3: {
                    sX = (int)(t.getX() + (t.getWidth() - (float)cX - 1.0f) - (float)cW);
                    sY = (int)(t.getY() + (t.getHeight() - (float)cY - 1.0f) - (float)cH);
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 4: {
                    sX = (int)(t.getX() + (float)cY);
                    sY = (int)(t.getY() + (float)cX);
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 5: {
                    sX = (int)(t.getX() + (t.getHeight() - (float)cY - 1.0f) - (float)cH);
                    sY = (int)(t.getY() + (float)cX);
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 7: {
                    sX = (int)(t.getX() + (t.getHeight() - (float)cY - 1.0f) - (float)cH);
                    sY = (int)(t.getY() + (t.getWidth() - (float)cX - 1.0f) - (float)cW);
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 6: {
                    sX = (int)(t.getX() + (float)cY);
                    sY = (int)(t.getY() + (t.getWidth() - (float)cX - 1.0f) - (float)cW);
                    sW = cH;
                    sH = cW;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (o != t) {
                tX = sX;
                tY = sY;
                tW = sW;
                tH = sH;
                if (o instanceof Sprite) {
                    t = (Sprite)o;
                    continue;
                }
                if (o instanceof TiledLayer) {
                    another = false;
                    TiledLayer layer = (TiledLayer)o;
                    oX = (int)layer.getX();
                    oY = (int)layer.getY();
                    oW = (int)layer.getWidth();
                    oH = (int)layer.getHeight();
                    continue;
                }
                another = false;
                TextureRegion img = (TextureRegion)o;
                oW = img.getRegionWidth();
                oH = img.getRegionHeight();
                continue;
            }
            another = false;
            oX = sX;
            oY = sY;
            oW = sW;
            oH = sH;
        }
        if (tX > oX && tX >= oX + oW) {
            return false;
        }
        if (tX < oX && tX + tW <= oX) {
            return false;
        }
        if (tY > oY && tY >= oY + oH) {
            return false;
        }
        if (tY < oY && tY + tH <= oY) {
            return false;
        }
        if (o instanceof TiledLayer) {
            int rH;
            int rY;
            int rW;
            int rX;
            TiledLayer layer = (TiledLayer)o;
            if (oX > tX) {
                rX = oX;
                rW = (oX + oW < tX + tW ? oX + oW : tX + tW) - rX;
            } else {
                rX = tX;
                rW = (tX + tW < oX + oW ? tX + tW : oX + oW) - rX;
            }
            if (oY > tY) {
                rY = oY;
                rH = (oY + oH < tY + tH ? oY + oH : tY + tH) - rY;
            } else {
                rY = tY;
                rH = (tY + tH < oY + oH ? tY + tH : oY + oH) - rY;
            }
            int lW = layer.getCellWidth();
            int lH = layer.getCellHeight();
            int minC = (rX - oX) / lW;
            int minR = (rY - oY) / lH;
            int maxC = (rX - oX + rW - 1) / lW;
            int maxR = (rY - oY + rH - 1) / lH;
            for (int row = minR; row <= maxR; ++row) {
                for (int col = minC; col <= maxC; ++col) {
                    int cell = layer.getCell(col, row);
                    if (cell < 0) {
                        cell = layer.getAnimatedTile(cell);
                    }
                    if (cell == 0) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

