/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.maps.tiled.tiles;

import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.game.maps.MapProperties;
import com.guidebee.game.maps.tiled.TiledMapTile;
import com.guidebee.math.geometry.Circle;
import com.guidebee.math.geometry.Polygon;
import com.guidebee.math.geometry.Rectangle;

public class StaticTiledMapTile
implements TiledMapTile {
    private int id;
    private TiledMapTile.BlendMode blendMode = TiledMapTile.BlendMode.ALPHA;
    private MapProperties properties;
    private TextureRegion textureRegion;
    private float offsetX;
    private float offsetY;
    private Object userObject;
    private Rectangle boundingRect;
    private Polygon boundingPolygon = new Polygon();
    private Circle boundingCircle = new Circle();
    private boolean collisionEnabled = false;

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public TiledMapTile.BlendMode getBlendMode() {
        return this.blendMode;
    }

    @Override
    public void setBlendMode(TiledMapTile.BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    @Override
    public MapProperties getProperties() {
        if (this.properties == null) {
            this.properties = new MapProperties();
        }
        return this.properties;
    }

    @Override
    public TextureRegion getTextureRegion() {
        return this.textureRegion;
    }

    @Override
    public void setTextureRegion(TextureRegion textureRegion) {
        this.textureRegion = textureRegion;
    }

    @Override
    public float getOffsetX() {
        return this.offsetX;
    }

    @Override
    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    @Override
    public float getOffsetY() {
        return this.offsetY;
    }

    @Override
    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    public StaticTiledMapTile(TextureRegion textureRegion) {
        this.textureRegion = textureRegion;
    }

    public StaticTiledMapTile(StaticTiledMapTile copy) {
        if (copy.properties != null) {
            this.getProperties().putAll(copy.properties);
        }
        this.textureRegion = copy.textureRegion;
        this.id = copy.id;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setBoundingRect(Rectangle rect) {
        this.boundingRect = rect;
    }

    public void setCollisionEnabled(Boolean value) {
        this.collisionEnabled = value;
    }

    @Override
    public boolean isEnabled() {
        return this.collisionEnabled;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public Rectangle getBoundingAABB() {
        return this.boundingRect;
    }

    @Override
    public Polygon getBoundingPolygon() {
        if (this.boundingRect != null) {
            float[] vertices = new float[]{this.boundingRect.x, this.boundingRect.y, this.boundingRect.x + this.boundingRect.width, this.boundingRect.y, this.boundingRect.x + this.boundingRect.width, this.boundingRect.y + this.boundingRect.height, this.boundingRect.y, this.boundingRect.y + this.boundingRect.height};
            this.boundingPolygon.setVertices(vertices);
            return this.boundingPolygon;
        }
        return null;
    }

    @Override
    public Circle getBoundingCircle() {
        if (this.boundingRect != null) {
            this.boundingCircle.setPosition(this.boundingRect.x + this.boundingRect.width / 2.0f, this.boundingRect.y + this.boundingRect.height / 2.0f);
            this.boundingCircle.setRadius(Math.min(this.boundingRect.width / 2.0f, this.boundingRect.height / 2.0f));
            return this.boundingCircle;
        }
        return null;
    }
}

