/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.maps.tiled.tiles;

import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.game.maps.MapProperties;
import com.guidebee.game.maps.tiled.TiledMapTile;
import com.guidebee.game.maps.tiled.tiles.StaticTiledMapTile;
import com.guidebee.math.geometry.Circle;
import com.guidebee.math.geometry.Polygon;
import com.guidebee.math.geometry.Rectangle;
import com.guidebee.utils.TimeUtils;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.LongArray;

public class AnimatedTiledMapTile
implements TiledMapTile {
    private static long lastTiledMapRenderTime = 0L;
    private int id;
    private TiledMapTile.BlendMode blendMode = TiledMapTile.BlendMode.ALPHA;
    private MapProperties properties;
    private StaticTiledMapTile[] frameTiles;
    private long[] animationIntervals;
    private long frameCount = 0L;
    private long loopDuration;
    private static final long initialTimeOffset = TimeUtils.millis();
    private boolean collisionEnabled = false;
    private Object userObject;
    private Rectangle boundingRect;
    private Polygon boundingPolygon = new Polygon();
    private Circle boundingCircle = new Circle();

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public TiledMapTile.BlendMode getBlendMode() {
        return this.blendMode;
    }

    @Override
    public void setBlendMode(TiledMapTile.BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    private TiledMapTile getCurrentFrame() {
        long currentTime = lastTiledMapRenderTime % this.loopDuration;
        for (int i = 0; i < this.animationIntervals.length; ++i) {
            long animationInterval = this.animationIntervals[i];
            if (currentTime <= animationInterval) {
                return this.frameTiles[i];
            }
            currentTime -= animationInterval;
        }
        throw new GameEngineRuntimeException("Could not determine current animation frame in AnimatedTiledMapTile.  This should never happen.");
    }

    @Override
    public TextureRegion getTextureRegion() {
        return this.getCurrentFrame().getTextureRegion();
    }

    @Override
    public void setTextureRegion(TextureRegion textureRegion) {
        throw new GameEngineRuntimeException("Cannot set the texture region of AnimatedTiledMapTile.");
    }

    @Override
    public float getOffsetX() {
        return this.getCurrentFrame().getOffsetX();
    }

    @Override
    public void setOffsetX(float offsetX) {
        throw new GameEngineRuntimeException("Cannot set offset of AnimatedTiledMapTile.");
    }

    @Override
    public float getOffsetY() {
        return this.getCurrentFrame().getOffsetY();
    }

    @Override
    public void setOffsetY(float offsetY) {
        throw new GameEngineRuntimeException("Cannot set offset of AnimatedTiledMapTile.");
    }

    @Override
    public MapProperties getProperties() {
        if (this.properties == null) {
            this.properties = new MapProperties();
        }
        return this.properties;
    }

    public static void updateAnimationBaseTime() {
        lastTiledMapRenderTime = TimeUtils.millis() - initialTimeOffset;
    }

    public AnimatedTiledMapTile(float interval, Array<StaticTiledMapTile> frameTiles) {
        this.frameTiles = new StaticTiledMapTile[frameTiles.size];
        this.frameCount = frameTiles.size;
        this.loopDuration = (long)((float)frameTiles.size * interval * 1000.0f);
        this.animationIntervals = new long[frameTiles.size];
        for (int i = 0; i < frameTiles.size; ++i) {
            this.frameTiles[i] = frameTiles.get(i);
            this.animationIntervals[i] = (long)(interval * 1000.0f);
        }
    }

    public AnimatedTiledMapTile(LongArray intervals, Array<StaticTiledMapTile> frameTiles) {
        this.frameTiles = new StaticTiledMapTile[frameTiles.size];
        this.frameCount = frameTiles.size;
        this.animationIntervals = intervals.toArray();
        this.loopDuration = 0L;
        for (int i = 0; i < intervals.size; ++i) {
            this.frameTiles[i] = frameTiles.get(i);
            this.loopDuration += intervals.get(i);
        }
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setCollisionEnabled(Boolean value) {
        this.collisionEnabled = value;
    }

    @Override
    public boolean isEnabled() {
        return this.collisionEnabled;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void setBoundingRect(Rectangle rect) {
        this.boundingRect = rect;
    }

    @Override
    public Rectangle getBoundingAABB() {
        return this.boundingRect;
    }

    @Override
    public Polygon getBoundingPolygon() {
        if (this.boundingRect != null) {
            float[] vertices = new float[]{this.boundingRect.x, this.boundingRect.y, this.boundingRect.x + this.boundingRect.width, this.boundingRect.y, this.boundingRect.x + this.boundingRect.width, this.boundingRect.y + this.boundingRect.height, this.boundingRect.y, this.boundingRect.y + this.boundingRect.height};
            this.boundingPolygon.setVertices(vertices);
            return this.boundingPolygon;
        }
        return null;
    }

    @Override
    public Circle getBoundingCircle() {
        if (this.boundingRect != null) {
            this.boundingCircle.setPosition(this.boundingRect.x + this.boundingRect.width / 2.0f, this.boundingRect.y + this.boundingRect.height / 2.0f);
            this.boundingCircle.setRadius(Math.min(this.boundingRect.width / 2.0f, this.boundingRect.height / 2.0f));
            return this.boundingCircle;
        }
        return null;
    }
}

