/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.input;

import com.guidebee.game.GameEngine;
import com.guidebee.game.Input;
import com.guidebee.game.InputProcessor;
import java.io.DataOutputStream;
import java.net.Socket;

public class RemoteSender
implements InputProcessor {
    private DataOutputStream out;
    private boolean connected = false;
    public static final int KEY_DOWN = 0;
    public static final int KEY_UP = 1;
    public static final int KEY_TYPED = 2;
    public static final int TOUCH_DOWN = 3;
    public static final int TOUCH_UP = 4;
    public static final int TOUCH_DRAGGED = 5;
    public static final int ACCEL = 6;
    public static final int COMPASS = 7;
    public static final int SIZE = 8;

    public RemoteSender(String ip, int port) {
        try {
            Socket socket = new Socket(ip, port);
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(3000);
            this.out = new DataOutputStream(socket.getOutputStream());
            this.out.writeBoolean(GameEngine.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen));
            this.connected = true;
            GameEngine.input.setInputProcessor(this);
        }
        catch (Exception e) {
            GameEngine.app.log("RemoteSender", "couldn't connect to " + ip + ":" + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdate() {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return;
            }
        }
        try {
            this.out.writeInt(6);
            this.out.writeFloat(GameEngine.input.getAccelerometerX());
            this.out.writeFloat(GameEngine.input.getAccelerometerY());
            this.out.writeFloat(GameEngine.input.getAccelerometerZ());
            this.out.writeInt(7);
            this.out.writeFloat(GameEngine.input.getAzimuth());
            this.out.writeFloat(GameEngine.input.getPitch());
            this.out.writeFloat(GameEngine.input.getRoll());
            this.out.writeInt(8);
            this.out.writeFloat(GameEngine.graphics.getWidth());
            this.out.writeFloat(GameEngine.graphics.getHeight());
        }
        catch (Throwable t) {
            this.out = null;
            this.connected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyDown(int keycode) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(0);
            this.out.writeInt(keycode);
        }
        catch (Throwable t) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyUp(int keycode) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(1);
            this.out.writeInt(keycode);
        }
        catch (Throwable t) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyTyped(char character) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(2);
            this.out.writeChar(character);
        }
        catch (Throwable t) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(3);
            this.out.writeInt(x);
            this.out.writeInt(y);
            this.out.writeInt(pointer);
        }
        catch (Throwable t) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(4);
            this.out.writeInt(x);
            this.out.writeInt(y);
            this.out.writeInt(pointer);
        }
        catch (Throwable t) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(5);
            this.out.writeInt(x);
            this.out.writeInt(y);
            this.out.writeInt(pointer);
        }
        catch (Throwable t) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    @Override
    public boolean mouseMoved(int x, int y) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            return this.connected;
        }
    }
}

