/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.entity;

import com.guidebee.game.engine.utils.reflect.ClassReflection;
import com.guidebee.game.entity.DataTrait;
import com.guidebee.game.entity.Entity;
import com.guidebee.game.entity.EntityEngine;
import com.guidebee.utils.Pool;
import com.guidebee.utils.ReflectionPool;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.ObjectMap;

public class PooledEntityEngine
extends EntityEngine {
    private EntityPool entityPool;
    private DataTraitPools dataTraitPools;

    public PooledEntityEngine() {
        this(10, 100, 10, 100);
    }

    public PooledEntityEngine(int entityPoolInitialSize, int entityPoolMaxSize, int dataTraitPoolInitialSize, int dataTraitPoolMaxSize) {
        this.entityPool = new EntityPool(entityPoolInitialSize, entityPoolMaxSize);
        this.dataTraitPools = new DataTraitPools(dataTraitPoolInitialSize, dataTraitPoolMaxSize);
    }

    public Entity createEntity() {
        return (Entity)this.entityPool.obtain();
    }

    public <T extends DataTrait> T createDataTrait(Class<T> dataTraitType) {
        return (T)((DataTrait)this.dataTraitPools.obtain(dataTraitType));
    }

    public void clearPools() {
        this.entityPool.clear();
        this.dataTraitPools.clear();
    }

    @Override
    protected void removeEntityInternal(Entity entity) {
        super.removeEntityInternal(entity);
        if (ClassReflection.isAssignableFrom(PooledEntity.class, entity.getClass())) {
            PooledEntity pooledEntity = (PooledEntity)entity;
            this.entityPool.free(pooledEntity);
        }
    }

    private class DataTraitPools {
        private ObjectMap<Class<?>, ReflectionPool> pools = new ObjectMap();
        private int initialSize = 0;
        private int maxSize = 0;

        public DataTraitPools(int initialSize, int maxSize) {
        }

        public <T> T obtain(Class<T> type) {
            ReflectionPool<T> pool = this.pools.get(type);
            if (pool == null) {
                pool = new ReflectionPool<T>(type, this.initialSize, this.maxSize);
                this.pools.put(type, pool);
            }
            return pool.obtain();
        }

        public void free(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("object cannot be null.");
            }
            ReflectionPool pool = this.pools.get(object.getClass());
            if (pool == null) {
                return;
            }
            pool.free(object);
        }

        public void freeAll(Array objects) {
            if (objects == null) {
                throw new IllegalArgumentException("objects cannot be null.");
            }
            int n = objects.size;
            for (int i = 0; i < n; ++i) {
                Object object = objects.get(i);
                if (object == null) continue;
                this.free(object);
            }
        }

        public void clear() {
            for (Pool pool : this.pools.values()) {
                pool.clear();
            }
        }
    }

    private class EntityPool
    extends Pool<PooledEntity> {
        public EntityPool(int initialSize, int maxSize) {
            super(initialSize, maxSize);
        }

        @Override
        protected PooledEntity newObject() {
            return new PooledEntity();
        }
    }

    private class PooledEntity
    extends Entity
    implements Pool.Poolable {
        private PooledEntity() {
        }

        @Override
        DataTrait removeInternal(Class<? extends DataTrait> dataTraitType) {
            DataTrait dataTrait = super.removeInternal(dataTraitType);
            PooledEntityEngine.this.dataTraitPools.free(dataTrait);
            return dataTrait;
        }

        @Override
        public void reset() {
            this.removeAll();
            this.flags = 0;
        }
    }
}

