/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.entity;

import com.guidebee.game.entity.DataTrait;
import com.guidebee.game.entity.Entity;
import com.guidebee.game.entity.EntityListener;
import com.guidebee.game.entity.Role;
import com.guidebee.game.entity.directors.Director;
import com.guidebee.game.entity.signals.Listener;
import com.guidebee.game.entity.signals.Signal;
import com.guidebee.game.entity.utils.ImmutableArray;
import com.guidebee.utils.Pool;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.ObjectMap;
import com.guidebee.utils.collections.SnapshotArray;
import java.util.Comparator;

public class EntityEngine {
    private static DirectorComparator comparator = new DirectorComparator();
    private Array<Entity> entities = new Array(false, 16);
    private Array<Entity> pendingRemovalEntities = new Array(false, 16);
    private Array<Director> directors = new Array(false, 16);
    private ImmutableArray<Director> immutableDirectors = new ImmutableArray<Director>(this.directors);
    private ObjectMap<Class<?>, Director> directorsByClass = new ObjectMap();
    private ObjectMap<Role, Array<Entity>> families = new ObjectMap();
    private ObjectMap<Role, ImmutableArray<Entity>> immutableFamilies = new ObjectMap();
    private SnapshotArray<EntityListener> listeners = new SnapshotArray(false, 16);
    private ObjectMap<Role, SnapshotArray<EntityListener>> familyListeners = new ObjectMap();
    private final Listener<Entity> dataTraitAdded = new Listener<Entity>(){

        @Override
        public void receive(Signal<Entity> signal, Entity object) {
            EntityEngine.this.updateFamilyMembership(object);
        }
    };
    private final Listener<Entity> dataTraitRemoved = new Listener<Entity>(){

        @Override
        public void receive(Signal<Entity> signal, Entity object) {
            EntityEngine.this.updateFamilyMembership(object);
        }
    };
    private boolean updating = false;
    private Object userObject;
    private DataTraitOperationPool dataTraitOperationsPool = new DataTraitOperationPool();
    private Array<DataTraitOperation> dataTraitOperations = new Array();
    private DataTraitOperationHandler dataTraitOperationHandler = new DataTraitOperationHandler(){

        @Override
        public void add(Entity entity, DataTrait dataTrait) {
            if (EntityEngine.this.updating) {
                DataTraitOperation operation = (DataTraitOperation)EntityEngine.this.dataTraitOperationsPool.obtain();
                operation.makeAdd(entity, dataTrait);
                EntityEngine.this.dataTraitOperations.add(operation);
            } else {
                entity.addInternal(dataTrait);
            }
        }

        @Override
        public void remove(Entity entity, Class<? extends DataTrait> dataTraitClass) {
            if (EntityEngine.this.updating) {
                DataTraitOperation operation = (DataTraitOperation)EntityEngine.this.dataTraitOperationsPool.obtain();
                operation.makeRemove(entity, dataTraitClass);
                EntityEngine.this.dataTraitOperations.add(operation);
            } else {
                entity.removeInternal(dataTraitClass);
            }
        }
    };

    public void addEntity(Entity entity) {
        this.entities.add(entity);
        this.updateFamilyMembership(entity);
        entity.dataTraitAdded.add(this.dataTraitAdded);
        entity.dataTraitRemoved.add(this.dataTraitRemoved);
        entity.dataTraitOperationHandler = this.dataTraitOperationHandler;
        EntityListener[] items = this.listeners.begin();
        int n = this.listeners.size;
        for (int i = 0; i < n; ++i) {
            EntityListener listener = items[i];
            listener.entityAdded(entity);
        }
        this.listeners.end();
    }

    public void removeEntity(Entity entity) {
        if (this.updating) {
            this.pendingRemovalEntities.add(entity);
        } else {
            this.removeEntityInternal(entity);
        }
    }

    public void removeAllEntities() {
        while (this.entities.size > 0) {
            this.removeEntity(this.entities.first());
        }
    }

    public void addDirector(Director director) {
        Class<?> directorType = director.getClass();
        if (!this.directorsByClass.containsKey(directorType)) {
            this.directors.add(director);
            this.directorsByClass.put(directorType, director);
            director.addedToEngine(this);
            this.directors.sort(comparator);
        }
    }

    public void removeDirector(Director director) {
        if (this.directors.removeValue(director, true)) {
            this.directorsByClass.remove(director.getClass());
            director.removedFromEngine(this);
        }
    }

    public <T extends Director> T getDirector(Class<T> directorType) {
        return (T)this.directorsByClass.get(directorType);
    }

    public ImmutableArray<Director> getDirectors() {
        return this.immutableDirectors;
    }

    public ImmutableArray<Entity> getEntitiesFor(Role role) {
        this.registerFamily(role);
        return this.immutableFamilies.get(role);
    }

    public void addEntityListener(EntityListener listener) {
        this.listeners.add(listener);
    }

    public void addEntityListener(Role role, EntityListener listener) {
        this.registerFamily(role);
        SnapshotArray<EntityListener> listeners = this.familyListeners.get(role);
        if (listeners == null) {
            listeners = new SnapshotArray(false, 16);
            this.familyListeners.put(role, listeners);
        }
        listeners.add(listener);
    }

    public void removeEntityListener(EntityListener listener) {
        this.listeners.removeValue(listener, true);
        for (SnapshotArray<EntityListener> familyListenerArray : this.familyListeners.values()) {
            familyListenerArray.removeValue(listener, true);
        }
    }

    public void update(float deltaTime) {
        this.updating = true;
        for (int i = 0; i < this.directors.size; ++i) {
            if (this.directors.get(i).checkProcessing()) {
                this.directors.get(i).direct(deltaTime);
            }
            this.processDataTraitOperations();
            this.removePendingEntities();
        }
        this.updating = false;
    }

    private void updateFamilyMembership(Entity entity) {
        for (ObjectMap.Entry<Role, Array<Entity>> entry : this.families.entries()) {
            Role role = (Role)entry.key;
            Array entities = (Array)entry.value;
            int familyIndex = role.getIndex();
            boolean belongsToFamily = entity.getFamilyBits().get(familyIndex);
            boolean matches = role.matches(entity);
            if (!belongsToFamily && matches) {
                entities.add(entity);
                entity.getFamilyBits().set(familyIndex);
                this.notifyFamilyListenersAdd(role, entity);
                continue;
            }
            if (!belongsToFamily || matches) continue;
            entities.removeValue(entity, true);
            entity.getFamilyBits().clear(familyIndex);
            this.notifyFamilyListenersRemove(role, entity);
        }
    }

    private void removePendingEntities() {
        int numPending = this.pendingRemovalEntities.size;
        for (int i = 0; i < numPending; ++i) {
            this.removeEntityInternal(this.pendingRemovalEntities.get(i));
        }
        this.pendingRemovalEntities.clear();
    }

    /*
     * WARNING - void declaration
     */
    protected void removeEntityInternal(Entity entity) {
        void var3_5;
        this.entities.removeValue(entity, true);
        if (!entity.getFamilyBits().isEmpty()) {
            for (ObjectMap.Entry<Role, Array<Entity>> entry : this.families.entries()) {
                Role role = (Role)entry.key;
                Array entities = (Array)entry.value;
                if (!role.matches(entity)) continue;
                entities.removeValue(entity, true);
                entity.getFamilyBits().clear(role.getIndex());
                this.notifyFamilyListenersRemove(role, entity);
            }
        }
        entity.dataTraitAdded.remove(this.dataTraitAdded);
        entity.dataTraitRemoved.remove(this.dataTraitRemoved);
        EntityListener[] items = this.listeners.begin();
        boolean bl = false;
        int n = this.listeners.size;
        while (var3_5 < n) {
            EntityListener listener = items[var3_5];
            listener.entityRemoved(entity);
            ++var3_5;
        }
        this.listeners.end();
    }

    private void notifyFamilyListenersAdd(Role role, Entity entity) {
        SnapshotArray<EntityListener> listeners = this.familyListeners.get(role);
        if (listeners != null) {
            EntityListener[] items = listeners.begin();
            int n = listeners.size;
            for (int i = 0; i < n; ++i) {
                EntityListener listener = items[i];
                listener.entityAdded(entity);
            }
            listeners.end();
        }
    }

    private void notifyFamilyListenersRemove(Role role, Entity entity) {
        SnapshotArray<EntityListener> listeners = this.familyListeners.get(role);
        if (listeners != null) {
            EntityListener[] items = listeners.begin();
            int n = listeners.size;
            for (int i = 0; i < n; ++i) {
                EntityListener listener = items[i];
                listener.entityRemoved(entity);
            }
            listeners.end();
        }
    }

    private Array<Entity> registerFamily(Role role) {
        Array<Entity> entities = this.families.get(role);
        if (entities == null) {
            entities = new Array(false, 16);
            this.families.put(role, entities);
            this.immutableFamilies.put(role, new ImmutableArray<Entity>(entities));
            for (Entity e : this.entities) {
                if (!role.matches(e)) continue;
                entities.add(e);
                e.getFamilyBits().set(role.getIndex());
            }
        }
        return entities;
    }

    private void processDataTraitOperations() {
        int numOperations = this.dataTraitOperations.size;
        for (int i = 0; i < numOperations; ++i) {
            DataTraitOperation operation = this.dataTraitOperations.get(i);
            if (operation.type == DataTraitOperation.Type.Add) {
                operation.entity.addInternal(operation.dataTrait);
            } else if (operation.type == DataTraitOperation.Type.Remove) {
                operation.entity.removeInternal(operation.dataTraitClass);
            }
            this.dataTraitOperationsPool.free(operation);
        }
        this.dataTraitOperations.clear();
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private static class DirectorComparator
    implements Comparator<Director> {
        private DirectorComparator() {
        }

        @Override
        public int compare(Director a, Director b) {
            return a.priority > b.priority ? 1 : (a.priority == b.priority ? 0 : -1);
        }
    }

    private static class DataTraitOperationPool
    extends Pool<DataTraitOperation> {
        private DataTraitOperationPool() {
        }

        @Override
        protected DataTraitOperation newObject() {
            return new DataTraitOperation();
        }
    }

    private static class DataTraitOperation {
        public Type type;
        public Entity entity;
        public DataTrait dataTrait;
        public Class<? extends DataTrait> dataTraitClass;

        private DataTraitOperation() {
        }

        public void makeAdd(Entity entity, DataTrait dataTrait) {
            this.type = Type.Add;
            this.entity = entity;
            this.dataTrait = dataTrait;
            this.dataTraitClass = null;
        }

        public void makeRemove(Entity entity, Class<? extends DataTrait> dataTraitClass) {
            this.type = Type.Remove;
            this.entity = entity;
            this.dataTrait = null;
            this.dataTraitClass = dataTraitClass;
        }

        public static enum Type {
            Add,
            Remove;

        }
    }

    static interface DataTraitOperationHandler {
        public void add(Entity var1, DataTrait var2);

        public void remove(Entity var1, Class<? extends DataTrait> var2);
    }
}

