/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.media.AudioManager;
import android.media.SoundPool;
import com.guidebee.utils.collections.IntArray;

final class Sound
implements com.guidebee.game.audio.Sound {
    final SoundPool soundPool;
    final AudioManager manager;
    final int soundId;
    final IntArray streamIds = new IntArray(8);

    Sound(SoundPool pool, AudioManager manager, int soundId) {
        this.soundPool = pool;
        this.manager = manager;
        this.soundId = soundId;
    }

    @Override
    public void dispose() {
        this.soundPool.unload(this.soundId);
    }

    @Override
    public long play() {
        return this.play(1.0f);
    }

    @Override
    public long play(float volume) {
        int streamId;
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        if ((streamId = this.soundPool.play(this.soundId, volume, volume, 1, 0, 1.0f)) == 0) {
            return -1L;
        }
        this.streamIds.add(streamId);
        return streamId;
    }

    @Override
    public void stop() {
        int n = this.streamIds.size;
        for (int i = 0; i < n; ++i) {
            this.soundPool.stop(this.streamIds.get(i));
        }
    }

    @Override
    public void stop(long soundId) {
        this.soundPool.stop((int)soundId);
    }

    @Override
    public void pause() {
        this.soundPool.autoPause();
    }

    @Override
    public void pause(long soundId) {
        this.soundPool.pause((int)soundId);
    }

    @Override
    public void resume() {
        this.soundPool.autoResume();
    }

    @Override
    public void resume(long soundId) {
        this.soundPool.resume((int)soundId);
    }

    @Override
    public void setPitch(long soundId, float pitch) {
        this.soundPool.setRate((int)soundId, pitch);
    }

    @Override
    public void setVolume(long soundId, float volume) {
        this.soundPool.setVolume((int)soundId, volume, volume);
    }

    @Override
    public long loop() {
        return this.loop(1.0f);
    }

    @Override
    public long loop(float volume) {
        int streamId;
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        if ((streamId = this.soundPool.play(this.soundId, volume, volume, 1, -1, 1.0f)) == 0) {
            return -1L;
        }
        this.streamIds.add(streamId);
        return streamId;
    }

    @Override
    public void setLooping(long soundId, boolean looping) {
        this.soundPool.setLoop((int)soundId, looping ? -1 : 0);
    }

    @Override
    public void setPan(long soundId, float pan, float volume) {
        float leftVolume = volume;
        float rightVolume = volume;
        if (pan < 0.0f) {
            rightVolume *= 1.0f - Math.abs(pan);
        } else if (pan > 0.0f) {
            leftVolume *= 1.0f - Math.abs(pan);
        }
        this.soundPool.setVolume((int)soundId, leftVolume, rightVolume);
    }

    @Override
    public long play(float volume, float pitch, float pan) {
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        float leftVolume = volume;
        float rightVolume = volume;
        if (pan < 0.0f) {
            rightVolume *= 1.0f - Math.abs(pan);
        } else if (pan > 0.0f) {
            leftVolume *= 1.0f - Math.abs(pan);
        }
        int streamId = this.soundPool.play(this.soundId, leftVolume, rightVolume, 1, 0, pitch);
        if (streamId == 0) {
            return -1L;
        }
        this.streamIds.add(streamId);
        return streamId;
    }

    @Override
    public long loop(float volume, float pitch, float pan) {
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        float leftVolume = volume;
        float rightVolume = volume;
        if (pan < 0.0f) {
            rightVolume *= 1.0f - Math.abs(pan);
        } else if (pan > 0.0f) {
            leftVolume *= 1.0f - Math.abs(pan);
        }
        int streamId = this.soundPool.play(this.soundId, leftVolume, rightVolume, 1, -1, pitch);
        if (streamId == 0) {
            return -1L;
        }
        this.streamIds.add(streamId);
        return streamId;
    }

    @Override
    public void setPriority(long soundId, int priority) {
        this.soundPool.setPriority((int)soundId, priority);
    }
}

