/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.media.MediaPlayer;
import com.guidebee.game.GameEngine;
import com.guidebee.game.audio.Music;
import com.guidebee.game.engine.platform.Audio;
import java.io.IOException;
import java.util.List;

public class Music
implements com.guidebee.game.audio.Music,
MediaPlayer.OnCompletionListener {
    private final Audio audio;
    private MediaPlayer player;
    private boolean isPrepared = true;
    protected boolean wasPlaying = false;
    private float volume = 1.0f;
    protected Music.OnCompletionListener onCompletionListener;

    Music(Audio audio, MediaPlayer player) {
        this.audio = audio;
        this.player = player;
        this.onCompletionListener = null;
        this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.player == null) {
            return;
        }
        try {
            if (this.player.isPlaying()) {
                this.player.stop();
            }
            this.player.release();
        }
        catch (Throwable t) {
            GameEngine.app.log("Music", "error while disposing Music instance, non-fatal");
        }
        finally {
            this.player = null;
            this.onCompletionListener = null;
            List<Music> list = this.audio.musics;
            synchronized (list) {
                this.audio.musics.remove(this);
            }
        }
    }

    @Override
    public boolean isLooping() {
        if (this.player == null) {
            return false;
        }
        return this.player.isLooping();
    }

    @Override
    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.player.isPlaying();
    }

    @Override
    public void pause() {
        if (this.player == null) {
            return;
        }
        if (this.player.isPlaying()) {
            this.player.pause();
        }
        this.wasPlaying = false;
    }

    @Override
    public void play() {
        if (this.player == null) {
            return;
        }
        if (this.player.isPlaying()) {
            return;
        }
        try {
            if (!this.isPrepared) {
                this.player.prepare();
                this.isPrepared = true;
            }
            this.player.start();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setLooping(boolean isLooping) {
        if (this.player == null) {
            return;
        }
        this.player.setLooping(isLooping);
    }

    @Override
    public void setVolume(float volume) {
        if (this.player == null) {
            return;
        }
        this.player.setVolume(volume, volume);
        this.volume = volume;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setPan(float pan, float volume) {
        if (this.player == null) {
            return;
        }
        float leftVolume = volume;
        float rightVolume = volume;
        if (pan < 0.0f) {
            rightVolume *= 1.0f - Math.abs(pan);
        } else if (pan > 0.0f) {
            leftVolume *= 1.0f - Math.abs(pan);
        }
        this.player.setVolume(leftVolume, rightVolume);
        this.volume = volume;
    }

    @Override
    public void stop() {
        if (this.player == null) {
            return;
        }
        if (this.isPrepared) {
            this.player.seekTo(0);
        }
        this.player.stop();
        this.isPrepared = false;
    }

    public void setPosition(float position) {
        if (this.player == null) {
            return;
        }
        try {
            if (!this.isPrepared) {
                this.player.prepare();
                this.isPrepared = true;
            }
            this.player.seekTo((int)(position * 1000.0f));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public float getPosition() {
        if (this.player == null) {
            return 0.0f;
        }
        return (float)this.player.getCurrentPosition() / 1000.0f;
    }

    public float getDuration() {
        if (this.player == null) {
            return 0.0f;
        }
        return (float)this.player.getDuration() / 1000.0f;
    }

    @Override
    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.onCompletionListener != null) {
            GameEngine.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    Music.this.onCompletionListener.onCompletion(Music.this);
                }
            });
        }
    }
}

