/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.content.Context;
import android.view.MotionEvent;
import com.guidebee.game.GameEngine;
import com.guidebee.game.engine.platform.ITouchHandler;
import com.guidebee.game.engine.platform.Input;

public class MultiTouchHandler
implements ITouchHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTouch(MotionEvent event, Input input) {
        int action = event.getAction() & 0xFF;
        int pointerIndex = (event.getAction() & 0xFF00) >> 8;
        int pointerId = event.getPointerId(pointerIndex);
        int x = 0;
        int y = 0;
        int realPointerIndex = 0;
        long timeStamp = System.nanoTime();
        Input input2 = input;
        synchronized (input2) {
            block2 : switch (action) {
                case 0: 
                case 5: {
                    realPointerIndex = input.getFreePointerIndex();
                    if (realPointerIndex >= 40) break;
                    input.realId[realPointerIndex] = pointerId;
                    x = (int)event.getX(pointerIndex);
                    y = (int)event.getY(pointerIndex);
                    this.postTouchEvent(input, 0, x, y, realPointerIndex, timeStamp);
                    input.touchX[realPointerIndex] = x;
                    input.touchY[realPointerIndex] = y;
                    input.deltaX[realPointerIndex] = 0;
                    input.deltaY[realPointerIndex] = 0;
                    input.touched[realPointerIndex] = true;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    realPointerIndex = input.lookUpPointerIndex(pointerId);
                    if (realPointerIndex == -1 || realPointerIndex >= 40) break;
                    input.realId[realPointerIndex] = -1;
                    x = (int)event.getX(pointerIndex);
                    y = (int)event.getY(pointerIndex);
                    this.postTouchEvent(input, 1, x, y, realPointerIndex, timeStamp);
                    input.touchX[realPointerIndex] = x;
                    input.touchY[realPointerIndex] = y;
                    input.deltaX[realPointerIndex] = 0;
                    input.deltaY[realPointerIndex] = 0;
                    input.touched[realPointerIndex] = false;
                    break;
                }
                case 2: {
                    int pointerCount = event.getPointerCount();
                    for (int i = 0; i < pointerCount; ++i) {
                        pointerIndex = i;
                        pointerId = event.getPointerId(pointerIndex);
                        x = (int)event.getX(pointerIndex);
                        y = (int)event.getY(pointerIndex);
                        realPointerIndex = input.lookUpPointerIndex(pointerId);
                        if (realPointerIndex == -1) continue;
                        if (realPointerIndex >= 40) break block2;
                        this.postTouchEvent(input, 2, x, y, realPointerIndex, timeStamp);
                        input.deltaX[realPointerIndex] = x - input.touchX[realPointerIndex];
                        input.deltaY[realPointerIndex] = y - input.touchY[realPointerIndex];
                        input.touchX[realPointerIndex] = x;
                        input.touchY[realPointerIndex] = y;
                    }
                    break;
                }
            }
        }
        GameEngine.app.getGraphics().requestRendering();
    }

    private void logAction(int action, int pointer) {
        String actionStr = "";
        actionStr = action == 0 ? "DOWN" : (action == 5 ? "POINTER DOWN" : (action == 1 ? "UP" : (action == 6 ? "POINTER UP" : (action == 4 ? "OUTSIDE" : (action == 3 ? "CANCEL" : (action == 2 ? "MOVE" : "UNKNOWN (" + action + ")"))))));
        GameEngine.app.log("MultiTouchHandler", "action " + actionStr + ", Android pointer id: " + pointer);
    }

    private void postTouchEvent(Input input, int type, int x, int y, int pointer, long timeStamp) {
        Input.TouchEvent event = input.usedTouchEvents.obtain();
        event.timeStamp = timeStamp;
        event.pointer = pointer;
        event.x = x;
        event.y = y;
        event.type = type;
        input.touchEvents.add(event);
    }

    @Override
    public boolean supportsMultitouch(Context activity) {
        return activity.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch");
    }
}

