/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Process;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import com.guidebee.game.Configuration;
import com.guidebee.game.GameEngine;
import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.Graphics;
import com.guidebee.game.LifecycleListener;
import com.guidebee.game.activity.BaseActivity;
import com.guidebee.game.engine.graphics.Mesh;
import com.guidebee.game.engine.graphics.opengles.IGL20;
import com.guidebee.game.engine.graphics.opengles.IGL30;
import com.guidebee.game.engine.graphics.opengles.ShaderProgram;
import com.guidebee.game.engine.platform.GL20;
import com.guidebee.game.engine.platform.surfaceview.EglConfigChooser;
import com.guidebee.game.engine.platform.surfaceview.GLSurfaceView20;
import com.guidebee.game.engine.platform.surfaceview.GLSurfaceView20API18;
import com.guidebee.game.engine.platform.surfaceview.GLSurfaceViewAPI18;
import com.guidebee.game.engine.platform.surfaceview.ResolutionStrategy;
import com.guidebee.game.graphics.FrameBuffer;
import com.guidebee.game.graphics.Texture;
import com.guidebee.math.WindowedMean;
import com.guidebee.utils.collections.Array;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class Graphics
implements com.guidebee.game.Graphics,
GLSurfaceView.Renderer {
    private static final String LOG_TAG = "Graphics";
    public final View view;
    int width;
    int height;
    BaseActivity app;
    IGL20 gl20;
    IGL30 gl30;
    EGLContext eglContext;
    String extensions;
    protected long lastFrameTime = System.nanoTime();
    protected float deltaTime = 0.0f;
    protected long frameStart = System.nanoTime();
    protected int frames = 0;
    protected int fps;
    protected WindowedMean mean = new WindowedMean(5);
    volatile boolean created = false;
    volatile boolean running = false;
    volatile boolean pause = false;
    volatile boolean resume = false;
    volatile boolean destroy = false;
    private float ppiX = 0.0f;
    private float ppiY = 0.0f;
    private float ppcX = 0.0f;
    private float ppcY = 0.0f;
    private float density = 1.0f;
    protected final Configuration config;
    private Graphics.BufferFormat bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 16, 0, 0, false);
    private boolean isContinuous = true;
    int[] value = new int[1];
    Object synch = new Object();

    public Graphics(BaseActivity application, Configuration config, ResolutionStrategy resolutionStrategy) {
        this(application, config, resolutionStrategy, true);
    }

    public Graphics(BaseActivity application, Configuration config, ResolutionStrategy resolutionStrategy, boolean focusableView) {
        this.config = config;
        this.app = application;
        this.view = this.createGLSurfaceView(application, resolutionStrategy);
        this.preserveEGLContextOnPause();
        if (focusableView) {
            this.view.setFocusable(true);
            this.view.setFocusableInTouchMode(true);
        }
    }

    protected void preserveEGLContextOnPause() {
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion >= 11 && this.view instanceof GLSurfaceView20 || this.view instanceof GLSurfaceView20API18) {
            try {
                this.view.getClass().getMethod("setPreserveEGLContextOnPause", Boolean.TYPE).invoke((Object)this.view, true);
            }
            catch (Exception e) {
                GameEngine.app.log(LOG_TAG, "Method GLSurfaceView.setPreserveEGLContextOnPause not found");
            }
        }
    }

    protected View createGLSurfaceView(BaseActivity application, ResolutionStrategy resolutionStrategy) {
        if (!this.checkGL20()) {
            throw new GameEngineRuntimeException("GameEngine requires OpenGL ES 2.0");
        }
        GLSurfaceView.EGLConfigChooser configChooser = this.getEglConfigChooser();
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion <= 10 && this.config.useGLSurfaceView20API18) {
            GLSurfaceView20API18 view = new GLSurfaceView20API18(application.getContext(), resolutionStrategy);
            if (configChooser != null) {
                view.setEGLConfigChooser(configChooser);
            } else {
                view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            view.setRenderer(this);
            return view;
        }
        GLSurfaceView20 view = new GLSurfaceView20(application.getContext(), resolutionStrategy);
        if (configChooser != null) {
            view.setEGLConfigChooser(configChooser);
        } else {
            view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
        }
        view.setRenderer(this);
        return view;
    }

    public void onPauseGLSurfaceView() {
        if (this.view != null) {
            if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).onPause();
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).onPause();
            }
        }
    }

    public void onResumeGLSurfaceView() {
        if (this.view != null) {
            if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).onResume();
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).onResume();
            }
        }
    }

    protected GLSurfaceView.EGLConfigChooser getEglConfigChooser() {
        return new EglConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil, this.config.numSamples);
    }

    private void updatePpi() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        this.ppiX = metrics.xdpi;
        this.ppiY = metrics.ydpi;
        this.ppcX = metrics.xdpi / 2.54f;
        this.ppcY = metrics.ydpi / 2.54f;
        this.density = metrics.density;
    }

    protected boolean checkGL20() {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] version = new int[2];
        egl.eglInitialize(display, version);
        int EGL_OPENGL_ES2_BIT = 4;
        int[] configAttribs = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        EGLConfig[] configs = new EGLConfig[10];
        int[] num_config = new int[1];
        egl.eglChooseConfig(display, configAttribs, configs, 10, num_config);
        egl.eglTerminate(display);
        return num_config[0] > 0;
    }

    @Override
    public IGL20 getGL20() {
        return this.gl20;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    private void setupGL(GL10 gl) {
        if (this.gl20 != null) {
            return;
        }
        GameEngine.gl = this.gl20 = new GL20();
        GameEngine.gl20 = this.gl20;
        GameEngine.app.log(LOG_TAG, "OGL renderer: " + gl.glGetString(7937));
        GameEngine.app.log(LOG_TAG, "OGL vendor: " + gl.glGetString(7936));
        GameEngine.app.log(LOG_TAG, "OGL version: " + gl.glGetString(7938));
        GameEngine.app.log(LOG_TAG, "OGL extensions: " + gl.glGetString(7939));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.width = width;
        this.height = height;
        this.updatePpi();
        gl.glViewport(0, 0, this.width, this.height);
        if (!this.created) {
            this.app.getApplicationListener().create();
            this.created = true;
            Graphics graphics = this;
            synchronized (graphics) {
                this.running = true;
            }
        }
        this.app.getApplicationListener().resize(width, height);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.eglContext = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        this.setupGL(gl);
        this.logConfig(config);
        this.updatePpi();
        Mesh.invalidateAllMeshes(this.app);
        Texture.invalidateAllTextures(this.app);
        ShaderProgram.invalidateAllShaderPrograms(this.app);
        FrameBuffer.invalidateAllFrameBuffers(this.app);
        this.logManagedCachesStatus();
        Display display = this.app.getWindowManager().getDefaultDisplay();
        this.width = display.getWidth();
        this.height = display.getHeight();
        this.mean = new WindowedMean(5);
        this.lastFrameTime = System.nanoTime();
        gl.glViewport(0, 0, this.width, this.height);
    }

    private void logConfig(EGLConfig config) {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int r = this.getAttrib(egl, display, config, 12324, 0);
        int g = this.getAttrib(egl, display, config, 12323, 0);
        int b = this.getAttrib(egl, display, config, 12322, 0);
        int a = this.getAttrib(egl, display, config, 12321, 0);
        int d = this.getAttrib(egl, display, config, 12325, 0);
        int s = this.getAttrib(egl, display, config, 12326, 0);
        int samples = Math.max(this.getAttrib(egl, display, config, 12337, 0), this.getAttrib(egl, display, config, 12513, 0));
        boolean coverageSample = this.getAttrib(egl, display, config, 12513, 0) != 0;
        GameEngine.app.log(LOG_TAG, "framebuffer: (" + r + ", " + g + ", " + b + ", " + a + ")");
        GameEngine.app.log(LOG_TAG, "depthbuffer: (" + d + ")");
        GameEngine.app.log(LOG_TAG, "stencilbuffer: (" + s + ")");
        GameEngine.app.log(LOG_TAG, "samples: (" + samples + ")");
        GameEngine.app.log(LOG_TAG, "coverage sampling: (" + coverageSample + ")");
        this.bufferFormat = new Graphics.BufferFormat(r, g, b, a, d, s, samples, coverageSample);
    }

    private int getAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attrib, int defValue) {
        if (egl.eglGetConfigAttrib(display, config, attrib, this.value)) {
            return this.value[0];
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.synch;
        synchronized (object) {
            this.running = true;
            this.resume = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.synch;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.pause = true;
            while (this.pause) {
                try {
                    this.synch.wait(4000L);
                    if (!this.pause) continue;
                    GameEngine.app.error(LOG_TAG, "waiting for pause synchronization took too long; assuming deadlock and killing");
                    Process.killProcess((int)Process.myPid());
                }
                catch (InterruptedException ignored) {
                    GameEngine.app.log(LOG_TAG, "waiting for pause synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.synch;
        synchronized (object) {
            this.running = false;
            this.destroy = true;
            while (this.destroy) {
                try {
                    this.synch.wait();
                }
                catch (InterruptedException ex) {
                    GameEngine.app.log(LOG_TAG, "waiting for destroy synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        Array<LifecycleListener> array;
        Array<Object> listeners;
        long time = System.nanoTime();
        this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = time;
        if (!this.resume) {
            this.mean.addValue(this.deltaTime);
        } else {
            this.deltaTime = 0.0f;
        }
        boolean lrunning = false;
        boolean lpause = false;
        boolean ldestroy = false;
        boolean lresume = false;
        Object object = this.synch;
        synchronized (object) {
            lrunning = this.running;
            lpause = this.pause;
            ldestroy = this.destroy;
            lresume = this.resume;
            if (this.resume) {
                this.resume = false;
            }
            if (this.pause) {
                this.pause = false;
                this.synch.notifyAll();
            }
            if (this.destroy) {
                this.destroy = false;
                this.synch.notifyAll();
            }
        }
        if (lresume) {
            listeners = this.app.getLifecycleListeners();
            array = listeners;
            synchronized (array) {
                for (LifecycleListener lifecycleListener : listeners) {
                    lifecycleListener.resume();
                }
            }
            this.app.getApplicationListener().resume();
            GameEngine.app.log(LOG_TAG, "resumed");
        }
        if (lrunning) {
            listeners = this.app.getRunnables();
            synchronized (listeners) {
                this.app.getExecutedRunnables().clear();
                this.app.getExecutedRunnables().addAll(this.app.getRunnables());
                this.app.getRunnables().clear();
            }
            for (int i = 0; i < this.app.getExecutedRunnables().size; ++i) {
                try {
                    this.app.getExecutedRunnables().get(i).run();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            this.app.getInput().processEvents();
            this.app.getApplicationListener().render();
        }
        if (lpause) {
            Array<LifecycleListener> listeners2;
            array = listeners2 = this.app.getLifecycleListeners();
            synchronized (array) {
                for (LifecycleListener lifecycleListener : listeners2) {
                    lifecycleListener.pause();
                }
            }
            this.app.getApplicationListener().pause();
            GameEngine.app.log(LOG_TAG, "paused");
        }
        if (ldestroy) {
            Array<LifecycleListener> listeners3;
            array = listeners3 = this.app.getLifecycleListeners();
            synchronized (array) {
                for (LifecycleListener lifecycleListener : listeners3) {
                    lifecycleListener.dispose();
                }
            }
            this.app.getApplicationListener().dispose();
            GameEngine.app.log(LOG_TAG, "destroyed");
        }
        if (time - this.frameStart > 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = time;
        }
        ++this.frames;
    }

    @Override
    public float getDeltaTime() {
        return this.mean.getMean() == 0.0f ? this.deltaTime : this.mean.getMean();
    }

    @Override
    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    public void clearManagedCaches() {
        Mesh.clearAllMeshes(this.app);
        Texture.clearAllTextures(this.app);
        ShaderProgram.clearAllShaderPrograms(this.app);
        FrameBuffer.clearAllFrameBuffers(this.app);
        this.logManagedCachesStatus();
    }

    protected void logManagedCachesStatus() {
        GameEngine.app.log(LOG_TAG, Mesh.getManagedStatus());
        GameEngine.app.log(LOG_TAG, Texture.getManagedStatus());
        GameEngine.app.log(LOG_TAG, ShaderProgram.getManagedStatus());
        GameEngine.app.log(LOG_TAG, FrameBuffer.getManagedStatus());
    }

    public View getView() {
        return this.view;
    }

    @Override
    public float getPpiX() {
        return this.ppiX;
    }

    @Override
    public float getPpiY() {
        return this.ppiY;
    }

    @Override
    public float getPpcX() {
        return this.ppcX;
    }

    @Override
    public float getPpcY() {
        return this.ppcY;
    }

    @Override
    public float getDensity() {
        return this.density;
    }

    @Override
    public boolean supportsDisplayModeChange() {
        return false;
    }

    @Override
    public boolean setDisplayMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDesktopDisplayMode()};
    }

    @Override
    public boolean setDisplayMode(int width, int height, boolean fullscreen) {
        return false;
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public Graphics.DisplayMode getDesktopDisplayMode() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return new AndroidDisplayMode(metrics.widthPixels, metrics.heightPixels, 0, 0);
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    @Override
    public void setVSync(boolean vsync) {
    }

    @Override
    public boolean supportsExtension(String extension) {
        if (this.extensions == null) {
            this.extensions = GameEngine.gl.glGetString(7939);
        }
        return this.extensions.contains(extension);
    }

    @Override
    public void setContinuousRendering(boolean isContinuous) {
        if (this.view != null) {
            int renderMode;
            this.isContinuous = isContinuous;
            int n = renderMode = isContinuous ? 1 : 0;
            if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).setRenderMode(renderMode);
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).setRenderMode(renderMode);
            }
            this.mean.clear();
        }
    }

    @Override
    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    @Override
    public void requestRendering() {
        if (this.view != null) {
            if (this.view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)this.view).requestRender();
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).requestRender();
            }
        }
    }

    @Override
    public boolean isFullscreen() {
        return true;
    }

    @Override
    public void clearScreen(float red, float green, float blue, float alpha) {
        this.gl20.glClearColor(red, green, blue, alpha);
        this.gl20.glClear(16384);
    }

    @Override
    public boolean isGL30Available() {
        return this.gl30 != null;
    }

    @Override
    public IGL30 getGL30() {
        return this.gl30;
    }

    private class AndroidDisplayMode
    extends Graphics.DisplayMode {
        protected AndroidDisplayMode(int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
        }
    }
}

