/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import com.guidebee.game.Files;
import com.guidebee.game.GameEngine;
import com.guidebee.game.GameEngineRuntimeException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

public class FileHandle
extends com.guidebee.game.files.FileHandle {
    final AssetManager assets;

    FileHandle(AssetManager assets, String fileName, Files.FileType type) {
        super(fileName.replace('\\', '/'), type);
        this.assets = assets;
    }

    FileHandle(AssetManager assets, File file, Files.FileType type) {
        super(file, type);
        this.assets = assets;
    }

    @Override
    public com.guidebee.game.files.FileHandle child(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            return new FileHandle(this.assets, new File(name), this.type);
        }
        return new FileHandle(this.assets, new File(this.file, name), this.type);
    }

    @Override
    public com.guidebee.game.files.FileHandle sibling(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            throw new GameEngineRuntimeException("Cannot get the sibling of the root.");
        }
        return new FileHandle(this.assets, new File(this.file.getParent(), name), this.type);
    }

    @Override
    public com.guidebee.game.files.FileHandle parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new FileHandle(this.assets, parent, this.type);
    }

    @Override
    public InputStream read() {
        if (this.type == Files.FileType.Internal) {
            try {
                return this.assets.open(this.file.getPath());
            }
            catch (IOException ex) {
                throw new GameEngineRuntimeException("Error reading file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
        }
        return super.read();
    }

    @Override
    public com.guidebee.game.files.FileHandle[] list() {
        if (this.type == Files.FileType.Internal) {
            try {
                String[] relativePaths = this.assets.list(this.file.getPath());
                com.guidebee.game.files.FileHandle[] handles = new com.guidebee.game.files.FileHandle[relativePaths.length];
                int n = handles.length;
                for (int i = 0; i < n; ++i) {
                    handles[i] = new FileHandle(this.assets, new File(this.file, relativePaths[i]), this.type);
                }
                return handles;
            }
            catch (Exception ex) {
                throw new GameEngineRuntimeException("Error listing children: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
        }
        return super.list();
    }

    @Override
    public com.guidebee.game.files.FileHandle[] list(FileFilter filter) {
        if (this.type == Files.FileType.Internal) {
            try {
                String[] relativePaths = this.assets.list(this.file.getPath());
                com.guidebee.game.files.FileHandle[] handles = new com.guidebee.game.files.FileHandle[relativePaths.length];
                int count = 0;
                int n = handles.length;
                for (int i = 0; i < n; ++i) {
                    String path = relativePaths[i];
                    FileHandle child = new FileHandle(this.assets, new File(this.file, path), this.type);
                    if (!filter.accept(((com.guidebee.game.files.FileHandle)child).file())) continue;
                    handles[count] = child;
                    ++count;
                }
                if (count < relativePaths.length) {
                    com.guidebee.game.files.FileHandle[] newHandles = new com.guidebee.game.files.FileHandle[count];
                    System.arraycopy(handles, 0, newHandles, 0, count);
                    handles = newHandles;
                }
                return handles;
            }
            catch (Exception ex) {
                throw new GameEngineRuntimeException("Error listing children: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
        }
        return super.list(filter);
    }

    @Override
    public com.guidebee.game.files.FileHandle[] list(FilenameFilter filter) {
        if (this.type == Files.FileType.Internal) {
            try {
                String[] relativePaths = this.assets.list(this.file.getPath());
                com.guidebee.game.files.FileHandle[] handles = new com.guidebee.game.files.FileHandle[relativePaths.length];
                int count = 0;
                int n = handles.length;
                for (int i = 0; i < n; ++i) {
                    String path = relativePaths[i];
                    if (!filter.accept(this.file, path)) continue;
                    handles[count] = new FileHandle(this.assets, new File(this.file, path), this.type);
                    ++count;
                }
                if (count < relativePaths.length) {
                    com.guidebee.game.files.FileHandle[] newHandles = new com.guidebee.game.files.FileHandle[count];
                    System.arraycopy(handles, 0, newHandles, 0, count);
                    handles = newHandles;
                }
                return handles;
            }
            catch (Exception ex) {
                throw new GameEngineRuntimeException("Error listing children: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
        }
        return super.list(filter);
    }

    @Override
    public com.guidebee.game.files.FileHandle[] list(String suffix) {
        if (this.type == Files.FileType.Internal) {
            try {
                String[] relativePaths = this.assets.list(this.file.getPath());
                com.guidebee.game.files.FileHandle[] handles = new com.guidebee.game.files.FileHandle[relativePaths.length];
                int count = 0;
                int n = handles.length;
                for (int i = 0; i < n; ++i) {
                    String path = relativePaths[i];
                    if (!path.endsWith(suffix)) continue;
                    handles[count] = new FileHandle(this.assets, new File(this.file, path), this.type);
                    ++count;
                }
                if (count < relativePaths.length) {
                    com.guidebee.game.files.FileHandle[] newHandles = new com.guidebee.game.files.FileHandle[count];
                    System.arraycopy(handles, 0, newHandles, 0, count);
                    handles = newHandles;
                }
                return handles;
            }
            catch (Exception ex) {
                throw new GameEngineRuntimeException("Error listing children: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
        }
        return super.list(suffix);
    }

    @Override
    public boolean isDirectory() {
        if (this.type == Files.FileType.Internal) {
            try {
                return this.assets.list(this.file.getPath()).length > 0;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return super.isDirectory();
    }

    @Override
    public boolean exists() {
        if (this.type == Files.FileType.Internal) {
            String fileName = this.file.getPath();
            try {
                this.assets.open(fileName).close();
                return true;
            }
            catch (Exception ex) {
                try {
                    return this.assets.list(fileName).length > 0;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return super.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        if (this.type == Files.FileType.Internal) {
            AssetFileDescriptor fileDescriptor = null;
            try {
                fileDescriptor = this.assets.openFd(this.file.getPath());
                long l = fileDescriptor.getLength();
                return l;
            }
            catch (IOException ignored) {
            }
            finally {
                if (fileDescriptor != null) {
                    try {
                        fileDescriptor.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return super.length();
    }

    @Override
    public long lastModified() {
        return super.lastModified();
    }

    @Override
    public File file() {
        if (this.type == Files.FileType.Local) {
            return new File(GameEngine.files.getLocalStoragePath(), this.file.getPath());
        }
        return super.file();
    }
}

