/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.media.AudioTrack;

class AudioDevice
implements com.guidebee.game.audio.AudioDevice {
    private final AudioTrack track;
    private short[] buffer = new short[1024];
    private final boolean isMono;
    private final int latency;

    AudioDevice(int samplingRate, boolean isMono) {
        this.isMono = isMono;
        int minSize = AudioTrack.getMinBufferSize((int)samplingRate, (int)(isMono ? 4 : 12), (int)2);
        this.track = new AudioTrack(3, samplingRate, isMono ? 4 : 12, 2, minSize, 1);
        this.track.play();
        this.latency = minSize / (isMono ? 1 : 2);
    }

    @Override
    public void dispose() {
        this.track.stop();
        this.track.release();
    }

    @Override
    public boolean isMono() {
        return this.isMono;
    }

    @Override
    public void writeSamples(short[] samples, int offset, int numSamples) {
        for (int writtenSamples = this.track.write(samples, offset, numSamples); writtenSamples != numSamples; writtenSamples += this.track.write(samples, offset + writtenSamples, numSamples - writtenSamples)) {
        }
    }

    @Override
    public void writeSamples(float[] samples, int offset, int numSamples) {
        if (this.buffer.length < samples.length) {
            this.buffer = new short[samples.length];
        }
        int bound = offset + numSamples;
        int i = offset;
        int j = 0;
        while (i < bound) {
            short value;
            float fValue = samples[i];
            if (fValue > 1.0f) {
                fValue = 1.0f;
            }
            if (fValue < -1.0f) {
                fValue = -1.0f;
            }
            this.buffer[j] = value = (short)(fValue * 32767.0f);
            ++i;
            ++j;
        }
        for (int writtenSamples = this.track.write(this.buffer, 0, numSamples); writtenSamples != numSamples; writtenSamples += this.track.write(this.buffer, writtenSamples, numSamples - writtenSamples)) {
        }
    }

    @Override
    public int getLatency() {
        return this.latency;
    }

    @Override
    public void setVolume(float volume) {
        this.track.setStereoVolume(volume, volume);
    }
}

