/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import com.guidebee.game.Configuration;
import com.guidebee.game.Files;
import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.engine.platform.AudioDevice;
import com.guidebee.game.engine.platform.AudioRecorder;
import com.guidebee.game.engine.platform.FileHandle;
import com.guidebee.game.engine.platform.Music;
import com.guidebee.game.engine.platform.Sound;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Audio
implements com.guidebee.game.Audio {
    private final SoundPool soundPool;
    private final AudioManager manager;
    protected final List<Music> musics = new ArrayList<Music>();

    public Audio(Context context, Configuration config) {
        if (!config.disableAudio) {
            this.soundPool = new SoundPool(config.maxSimultaneousSounds, 3, 100);
            this.manager = (AudioManager)context.getSystemService("audio");
            if (context instanceof Activity) {
                ((Activity)context).setVolumeControlStream(3);
            }
        } else {
            this.soundPool = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (this.soundPool == null) {
            return;
        }
        List<Music> list = this.musics;
        synchronized (list) {
            for (Music music : this.musics) {
                if (music.isPlaying()) {
                    music.pause();
                    music.wasPlaying = true;
                    continue;
                }
                music.wasPlaying = false;
            }
        }
        this.soundPool.autoPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (this.soundPool == null) {
            return;
        }
        List<Music> list = this.musics;
        synchronized (list) {
            for (int i = 0; i < this.musics.size(); ++i) {
                if (!this.musics.get((int)i).wasPlaying) continue;
                this.musics.get(i).play();
            }
        }
        this.soundPool.autoResume();
    }

    @Override
    public com.guidebee.game.audio.AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        if (this.soundPool == null) {
            throw new GameEngineRuntimeException("Android audio is not enabled by the application config.");
        }
        return new AudioDevice(samplingRate, isMono);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.guidebee.game.audio.Music newMusic(com.guidebee.game.files.FileHandle file) {
        if (this.soundPool == null) {
            throw new GameEngineRuntimeException("Android audio is not enabled by the application config.");
        }
        FileHandle aHandle = (FileHandle)file;
        MediaPlayer mediaPlayer = new MediaPlayer();
        if (aHandle.type() == Files.FileType.Internal) {
            try {
                AssetFileDescriptor descriptor = aHandle.assets.openFd(aHandle.path());
                mediaPlayer.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
                descriptor.close();
                mediaPlayer.prepare();
                Music music = new Music(this, mediaPlayer);
                List<Music> list = this.musics;
                synchronized (list) {
                    this.musics.add(music);
                }
                return music;
            }
            catch (Exception ex) {
                throw new GameEngineRuntimeException("Error loading audio file: " + file + "\nNote: Internal audio files must be placed in the assets directory.", ex);
            }
        }
        try {
            mediaPlayer.setDataSource(aHandle.file().getPath());
            mediaPlayer.prepare();
            Music music = new Music(this, mediaPlayer);
            List<Music> list = this.musics;
            synchronized (list) {
                this.musics.add(music);
            }
            return music;
        }
        catch (Exception ex) {
            throw new GameEngineRuntimeException("Error loading audio file: " + file, ex);
        }
    }

    @Override
    public com.guidebee.game.audio.Sound newSound(com.guidebee.game.files.FileHandle file) {
        if (this.soundPool == null) {
            throw new GameEngineRuntimeException("Android audio is not enabled by the application config.");
        }
        FileHandle aHandle = (FileHandle)file;
        if (aHandle.type() == Files.FileType.Internal) {
            try {
                AssetFileDescriptor descriptor = aHandle.assets.openFd(aHandle.path());
                Sound sound = new Sound(this.soundPool, this.manager, this.soundPool.load(descriptor, 1));
                descriptor.close();
                return sound;
            }
            catch (IOException ex) {
                throw new GameEngineRuntimeException("Error loading audio file: " + file + "\nNote: Internal audio files must be placed in the assets directory.", ex);
            }
        }
        try {
            return new Sound(this.soundPool, this.manager, this.soundPool.load(aHandle.file().getPath(), 1));
        }
        catch (Exception ex) {
            throw new GameEngineRuntimeException("Error loading audio file: " + file, ex);
        }
    }

    @Override
    public com.guidebee.game.audio.AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        if (this.soundPool == null) {
            throw new GameEngineRuntimeException("Android audio is not enabled by the application config.");
        }
        return new AudioRecorder(samplingRate, isMono);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.soundPool == null) {
            return;
        }
        List<Music> list = this.musics;
        synchronized (list) {
            ArrayList<Music> musicsCopy = new ArrayList<Music>(this.musics);
            for (Music music : musicsCopy) {
                music.dispose();
            }
        }
        this.soundPool.release();
    }
}

