/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.maps;

import com.guidebee.game.engine.assets.AssetManager;
import com.guidebee.game.graphics.Texture;
import com.guidebee.game.graphics.TextureAtlas;
import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.utils.collections.ObjectMap;

public interface ImageResolver {
    public TextureRegion getImage(String var1);

    public static class TextureAtlasImageResolver
    implements ImageResolver {
        private final TextureAtlas atlas;

        public TextureAtlasImageResolver(TextureAtlas atlas) {
            this.atlas = atlas;
        }

        @Override
        public TextureRegion getImage(String name) {
            return this.atlas.findRegion(name);
        }
    }

    public static class AssetManagerImageResolver
    implements ImageResolver {
        private final AssetManager assetManager;

        public AssetManagerImageResolver(AssetManager assetManager) {
            this.assetManager = assetManager;
        }

        @Override
        public TextureRegion getImage(String name) {
            return new TextureRegion(this.assetManager.get(name, Texture.class));
        }
    }

    public static class DirectImageResolver
    implements ImageResolver {
        private final ObjectMap<String, Texture> images;

        public DirectImageResolver(ObjectMap<String, Texture> images) {
            this.images = images;
        }

        @Override
        public TextureRegion getImage(String name) {
            return new TextureRegion(this.images.get(name));
        }
    }
}

