/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.graphics.opengles.profiling;

import com.guidebee.game.GameEngine;
import com.guidebee.game.engine.graphics.opengles.profiling.GL20Profiler;
import com.guidebee.game.engine.graphics.opengles.profiling.GL30Profiler;
import com.guidebee.math.FloatCounter;

public abstract class GLProfiler {
    public static int calls;
    public static int textureBindings;
    public static int drawCalls;
    public static int shaderSwitches;
    public static FloatCounter vertexCount;

    public static void enable() {
        GameEngine.gl30 = GameEngine.gl30 == null ? null : new GL30Profiler(GameEngine.gl30);
        GameEngine.gl = GameEngine.gl20 = GameEngine.gl30 != null ? GameEngine.gl30 : new GL20Profiler(GameEngine.gl20);
    }

    public static void disable() {
        if (GameEngine.gl30 != null && GameEngine.gl30 instanceof GL30Profiler) {
            GameEngine.gl30 = ((GL30Profiler)GameEngine.gl30).gl30;
        }
        if (GameEngine.gl20 != null && GameEngine.gl20 instanceof GL20Profiler) {
            GameEngine.gl20 = ((GL20Profiler)GameEngine.gl).gl20;
        }
        if (GameEngine.gl != null && GameEngine.gl instanceof GL20Profiler) {
            GameEngine.gl = ((GL20Profiler)GameEngine.gl).gl20;
        }
    }

    public static void reset() {
        calls = 0;
        textureBindings = 0;
        drawCalls = 0;
        shaderSwitches = 0;
        vertexCount.reset();
    }

    static {
        vertexCount = new FloatCounter(0);
    }
}

