/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.graphics.opengles;

import com.guidebee.game.GameEngine;
import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.graphics.Pixmap;

public class MipMapGenerator {
    private static boolean useHWMipMap = true;

    private MipMapGenerator() {
    }

    public static void setUseHardwareMipMap(boolean useHWMipMap) {
        MipMapGenerator.useHWMipMap = useHWMipMap;
    }

    public static void generateMipMap(Pixmap pixmap, int textureWidth, int textureHeight) {
        MipMapGenerator.generateMipMap(3553, pixmap, textureWidth, textureHeight);
    }

    public static void generateMipMap(int target, Pixmap pixmap, int textureWidth, int textureHeight) {
        if (!useHWMipMap) {
            MipMapGenerator.generateMipMapCPU(target, pixmap, textureWidth, textureHeight);
            return;
        }
        MipMapGenerator.generateMipMapGLES20(target, pixmap);
    }

    private static void generateMipMapGLES20(int target, Pixmap pixmap) {
        GameEngine.gl.glTexImage2D(target, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
        GameEngine.gl20.glGenerateMipmap(target);
    }

    private static void generateMipMapDesktop(int target, Pixmap pixmap, int textureWidth, int textureHeight) {
        if (GameEngine.graphics.supportsExtension("GL_ARB_framebuffer_object") || GameEngine.graphics.supportsExtension("GL_EXT_framebuffer_object") || GameEngine.gl30 != null) {
            GameEngine.gl.glTexImage2D(target, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
            GameEngine.gl20.glGenerateMipmap(target);
        } else {
            MipMapGenerator.generateMipMapCPU(target, pixmap, textureWidth, textureHeight);
        }
    }

    private static void generateMipMapCPU(int target, Pixmap pixmap, int textureWidth, int textureHeight) {
        GameEngine.gl.glTexImage2D(target, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
        if (GameEngine.gl20 == null && textureWidth != textureHeight) {
            throw new GameEngineRuntimeException("texture width and height must be square when using mipmapping.");
        }
        int width = pixmap.getWidth() / 2;
        int height = pixmap.getHeight() / 2;
        int level = 1;
        Pixmap.Blending blending = Pixmap.getBlending();
        Pixmap.setBlending(Pixmap.Blending.None);
        while (width > 0 && height > 0) {
            Pixmap tmp = new Pixmap(width, height, pixmap.getFormat());
            tmp.drawPixmap(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 0, 0, width, height);
            if (level > 1) {
                pixmap.dispose();
            }
            pixmap = tmp;
            GameEngine.gl.glTexImage2D(target, level, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
            width = pixmap.getWidth() / 2;
            height = pixmap.getHeight() / 2;
            ++level;
        }
        Pixmap.setBlending(blending);
    }
}

