/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.graphics;

import com.guidebee.game.GameEngine;
import com.guidebee.game.engine.graphics.opengles.ETC1TextureData;
import com.guidebee.game.engine.graphics.opengles.FileTextureData;
import com.guidebee.game.engine.graphics.opengles.MipMapGenerator;
import com.guidebee.game.files.FileHandle;
import com.guidebee.game.graphics.Pixmap;
import com.guidebee.game.graphics.Texture;
import com.guidebee.game.graphics.TextureData;
import com.guidebee.utils.Disposable;
import com.guidebee.utils.collections.BufferUtils;
import java.nio.IntBuffer;

public abstract class GLTexture
implements Disposable {
    private static final IntBuffer buffer = BufferUtils.newIntBuffer(1);
    public final int glTarget;
    protected int glHandle;
    protected Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
    protected Texture.TextureFilter magFilter = Texture.TextureFilter.Nearest;
    protected Texture.TextureWrap uWrap = Texture.TextureWrap.ClampToEdge;
    protected Texture.TextureWrap vWrap = Texture.TextureWrap.ClampToEdge;

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getDepth();

    public GLTexture(int glTarget) {
        this(glTarget, GLTexture.createGLHandle());
    }

    public GLTexture(int glTarget, int glHandle) {
        this.glTarget = glTarget;
        this.glHandle = glHandle;
    }

    public abstract boolean isManaged();

    protected abstract void reload();

    public void bind() {
        GameEngine.gl.glBindTexture(this.glTarget, this.glHandle);
    }

    public void bind(int unit) {
        GameEngine.gl.glActiveTexture(33984 + unit);
        GameEngine.gl.glBindTexture(this.glTarget, this.glHandle);
    }

    public Texture.TextureFilter getMinFilter() {
        return this.minFilter;
    }

    public Texture.TextureFilter getMagFilter() {
        return this.magFilter;
    }

    public Texture.TextureWrap getUWrap() {
        return this.uWrap;
    }

    public Texture.TextureWrap getVWrap() {
        return this.vWrap;
    }

    public int getTextureObjectHandle() {
        return this.glHandle;
    }

    public void unsafeSetWrap(Texture.TextureWrap u, Texture.TextureWrap v) {
        this.unsafeSetWrap(u, v, false);
    }

    public void unsafeSetWrap(Texture.TextureWrap u, Texture.TextureWrap v, boolean force) {
        if (u != null && (force || this.uWrap != u)) {
            GameEngine.gl.glTexParameterf(this.glTarget, 10242, u.getGLEnum());
            this.uWrap = u;
        }
        if (v != null && (force || this.vWrap != v)) {
            GameEngine.gl.glTexParameterf(this.glTarget, 10243, v.getGLEnum());
            this.vWrap = v;
        }
    }

    public void setWrap(Texture.TextureWrap u, Texture.TextureWrap v) {
        this.uWrap = u;
        this.vWrap = v;
        this.bind();
        GameEngine.gl.glTexParameterf(this.glTarget, 10242, u.getGLEnum());
        GameEngine.gl.glTexParameterf(this.glTarget, 10243, v.getGLEnum());
    }

    public void unsafeSetFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        this.unsafeSetFilter(minFilter, magFilter, false);
    }

    public void unsafeSetFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean force) {
        if (minFilter != null && (force || this.minFilter != minFilter)) {
            GameEngine.gl.glTexParameterf(this.glTarget, 10241, minFilter.getGLEnum());
            this.minFilter = minFilter;
        }
        if (magFilter != null && (force || this.magFilter != magFilter)) {
            GameEngine.gl.glTexParameterf(this.glTarget, 10240, magFilter.getGLEnum());
            this.magFilter = magFilter;
        }
    }

    public void setFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        this.minFilter = minFilter;
        this.magFilter = magFilter;
        this.bind();
        GameEngine.gl.glTexParameterf(this.glTarget, 10241, minFilter.getGLEnum());
        GameEngine.gl.glTexParameterf(this.glTarget, 10240, magFilter.getGLEnum());
    }

    protected void delete() {
        if (this.glHandle != 0) {
            buffer.put(0, this.glHandle);
            buffer.position(0);
            buffer.limit(1);
            GameEngine.gl.glDeleteTextures(1, buffer);
            this.glHandle = 0;
        }
    }

    @Override
    public void dispose() {
        this.delete();
    }

    protected static TextureData createTextureData(FileHandle file, Pixmap.Format format, boolean useMipMaps) {
        if (file == null) {
            return null;
        }
        if (file.name().endsWith(".etc1")) {
            return new ETC1TextureData(file, useMipMaps);
        }
        return new FileTextureData(file, null, format, useMipMaps);
    }

    protected static TextureData createTextureData(FileHandle file, boolean useMipMaps) {
        return GLTexture.createTextureData(file, null, useMipMaps);
    }

    protected static int createGLHandle() {
        buffer.position(0);
        buffer.limit(buffer.capacity());
        GameEngine.gl.glGenTextures(1, buffer);
        return buffer.get(0);
    }

    protected static void uploadImageData(int target, TextureData data) {
        GLTexture.uploadImageData(target, data, 0);
    }

    public static void uploadImageData(int target, TextureData data, int miplevel) {
        TextureData.TextureDataType type;
        if (data == null) {
            return;
        }
        if (!data.isPrepared()) {
            data.prepare();
        }
        if ((type = data.getType()) == TextureData.TextureDataType.Custom) {
            data.consumeCustomData(target);
            return;
        }
        Pixmap pixmap = data.consumePixmap();
        boolean disposePixmap = data.disposePixmap();
        if (data.getFormat() != pixmap.getFormat()) {
            Pixmap tmp = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), data.getFormat());
            Pixmap.Blending blend = Pixmap.getBlending();
            Pixmap.setBlending(Pixmap.Blending.None);
            tmp.drawPixmap(pixmap, 0, 0, 0, 0, pixmap.getWidth(), pixmap.getHeight());
            Pixmap.setBlending(blend);
            if (data.disposePixmap()) {
                pixmap.dispose();
            }
            pixmap = tmp;
            disposePixmap = true;
        }
        GameEngine.gl.glPixelStorei(3317, 1);
        if (data.useMipMaps()) {
            MipMapGenerator.generateMipMap(target, pixmap, pixmap.getWidth(), pixmap.getHeight());
        } else {
            GameEngine.gl.glTexImage2D(target, miplevel, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
        }
        if (disposePixmap) {
            pixmap.dispose();
        }
    }
}

