/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

public class SingleFP {
    private static final int POSITIVE_INFINITY = Integer.MAX_VALUE;
    private static final int NEGATIVE_INFINITY = Integer.MIN_VALUE;
    public static final int MAX_VALUE = 0x7FFFFFFE;
    public static final int MIN_VALUE = -2147483646;
    public static final int NaN = -2147483647;
    public static final int DECIMAL_BITS = 16;
    public static final int ONE = 65536;
    private int value;

    public SingleFP(int v) {
        this.value = v;
    }

    public SingleFP(SingleFP f) {
        this.value = f.value;
    }

    public static boolean isNaN(int x) {
        return x == -2147483647;
    }

    public static boolean isInfinity(int x) {
        return x == Integer.MIN_VALUE || x == Integer.MAX_VALUE;
    }

    public static boolean isNegativeInfinity(int x) {
        return x == Integer.MIN_VALUE;
    }

    public static boolean isPositiveInfinity(int x) {
        return x == Integer.MAX_VALUE;
    }

    public static int fromFloat(float f) {
        return (int)((double)(f * 65536.0f) + 0.5);
    }

    public static int fromDouble(double f) {
        return (int)(f * 65536.0 + 0.5);
    }

    public static float toFloat(int x) {
        return (float)x / 65536.0f;
    }

    public static double toDouble(int x) {
        return (double)x / 65536.0;
    }

    public static int fromInt(int x) {
        return x << 16;
    }

    public static int toInt(int ff_x) {
        return ff_x >> 16;
    }

    public static SingleFP parseSingle(String strValue) {
        int v;
        int posDot;
        String s = strValue;
        boolean e_neg = false;
        int e = 0;
        int posE = s.indexOf(69);
        if (posE == -1) {
            posE = s.indexOf(101);
        }
        if (posE != -1) {
            e = Integer.parseInt(s.substring(posE + 1));
            if (e < 0) {
                e_neg = true;
                e = -e;
            }
            s = s.substring(0, posE - 0);
        }
        if ((posDot = s.indexOf(46)) == -1) {
            v = Integer.parseInt(s);
            v <<= 16;
        } else {
            v = Integer.parseInt(s.substring(0, posDot - 0)) << 16;
            s = s.substring(posDot + 1);
            s = s + "0000";
            s = s.substring(0, 4);
            int f = Integer.parseInt(s);
            f = (f << 16) / 10000;
            v = v < 0 ? (v -= f) : (v += f);
        }
        for (int i = 0; i < e; ++i) {
            if (e_neg) {
                v /= 10;
                continue;
            }
            v *= 10;
        }
        return new SingleFP(v);
    }

    public String toString() {
        String s = "";
        int v = this.value;
        if (v < 0) {
            s = "-";
            v = -v;
        }
        s = s + (v >> 16);
        if ((v = 0xFFFF & v) != 0) {
            s = s + ".";
        }
        for (int i = 0; i < 4; ++i) {
            s = s + ((v *= 10) >> 16);
            v = 0xFFFF & v;
        }
        return s;
    }
}

