/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

public class MathFP {
    public static final int PI = 205887;
    public static final int E = 178145;

    public static int min(int x, int y) {
        return x < y ? x : y;
    }

    public static int max(int x, int y) {
        return x > y ? x : y;
    }

    public static int abs(int x) {
        return x < 0 ? -x : x;
    }

    public static int mul(int x, int y) {
        long res = (long)x * (long)y >> 16;
        return (int)res;
    }

    public static int div(int x, int y) {
        long res = ((long)x << 16) / (long)y;
        return (int)res;
    }

    public static int sqrt(int n) {
        int s = n < 65536000 ? n / 20 : (n < 163840000 ? n / 40 : (n < 327680000 ? n / 60 : (n < 655360000 ? n / 86 : (n < 1638400000 ? n / 132 : n / 168))));
        s = s + MathFP.div(n, s) >> 1;
        s = s + MathFP.div(n, s) >> 1;
        s = s + MathFP.div(n, s) >> 1;
        return s;
    }

    public static int IEEERemainder(int n, int m) {
        return n - MathFP.mul(MathFP.floor(MathFP.div(n, m)), m);
    }

    public static int floor(int x) {
        return x < 0 && (-x & 0xFFFF) != 0 ? -(-x + 65536 >> 16 << 16) : x >> 16 << 16;
    }

    public static int round(int x) {
        if (x < 0) {
            return -(-x + 32768 >> 16 << 16);
        }
        return x + 32768 >> 16 << 16;
    }

    public static int toDegrees(int f) {
        return MathFP.div(f * 180, 205887);
    }

    public static int toRadians(int f) {
        return MathFP.mul(f, 205887) / 180;
    }

    public static int sin(int f) {
        if (f < 0 || f >= 411774) {
            f = MathFP.IEEERemainder(f, 411774);
        }
        int sign = 1;
        if (f > 102943 && f <= 205887) {
            f = 205887 - f;
        } else if (f > 205887 && f <= 308830) {
            f -= 205887;
            sign = -1;
        } else if (f > 308830) {
            f = 411774 - f;
            sign = -1;
        }
        int sqr = MathFP.mul(f, f);
        int result = 498;
        result = MathFP.mul(result, sqr);
        result -= 10882;
        result = MathFP.mul(result, sqr);
        result += 65536;
        result = MathFP.mul(result, f);
        return sign * result;
    }

    public static int cos(int ff_ang) {
        return MathFP.sin(102943 - ff_ang);
    }

    public static int tan(int f) {
        return MathFP.div(MathFP.sin(f), MathFP.cos(f));
    }

    public static int atan(int ff_val) {
        int ff_val1 = ff_val > 65536 ? MathFP.div(65536, ff_val) : (ff_val < -65536 ? MathFP.div(65536, -ff_val) : ff_val);
        int sqr = MathFP.mul(ff_val1, ff_val1);
        int result = 1365;
        result = MathFP.mul(result, sqr);
        result -= 5579;
        result = MathFP.mul(result, sqr);
        result += 11805;
        result = MathFP.mul(result, sqr);
        result -= 21646;
        result = MathFP.mul(result, sqr);
        result += 65527;
        result = MathFP.mul(result, ff_val1);
        return ff_val > 65536 ? 102943 - result : (ff_val < -65536 ? -(102943 - result) : result);
    }

    public static int asin(int f) {
        return 102943 - MathFP.acos(f);
    }

    public static int acos(int f) {
        int fRoot = MathFP.sqrt(65536 - f);
        int result = -1228;
        result = MathFP.mul(result, f);
        result += 4866;
        result = MathFP.mul(result, f);
        result -= 13901;
        result = MathFP.mul(result, f);
        result += 102939;
        result = MathFP.mul(fRoot, result);
        return result;
    }

    public static long min(long x, long y) {
        return x < y ? x : y;
    }

    public static long max(long x, long y) {
        return x > y ? x : y;
    }

    public static long abs(long x) {
        return x < 0L ? -x : x;
    }
}

