/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.BrushFP;
import com.guidebee.game.engine.drawing.core.ColorFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathSketchFP;
import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.MatrixFP;
import com.guidebee.game.engine.drawing.core.PointFP;

class GraphicsPathRendererFP
extends GraphicsPathSketchFP {
    public static final int MODE_XOR = 1;
    public static final int MODE_ZERO = 2;
    int[] buffer = null;
    int backGroundColor = 0xFFFFFF;
    private static final int RENDERER_FRAC_Y = 4;
    private static final int RENDERER_FRAC_X = 4;
    private static final int RENDERER_REAL_X = 12;
    private static final int RENDERER_REAL_Y = 11;
    private static final int BUFFERSIZE = 2048;
    private static final int RENDERER_REAL_X_MASK = 4095;
    private static final int RENDERER_REAL_Y_MASK = 2047;
    private static final int RENDERER_FRAC_X_FACTOR = 16;
    private static final int RENDERER_FRAC_X_MASK = 15;
    private MatrixFP transformMatrix = null;
    private BrushFP fillStyle = null;
    private static int[] scanbuf = null;
    private static int[] scanbuf_tmp = null;
    private static int[] counts = new int[256];
    private static int[] index = new int[256];
    private PointFP transformedPoint;
    private int width = 0;
    private int height = 0;
    private int drawMode = 1;
    private int scanIndex = 0;
    private int ff_xmin = 0x7FFFFFFE;
    private int ff_xmax = -2147483646;
    private int ff_ymin = 0x7FFFFFFE;
    private int ff_ymax = -2147483646;
    int clipX = 0;
    int clipY = 0;
    int clipWidth = 0;
    int clipHeight = 0;

    public GraphicsPathRendererFP() {
        this(1, 1);
    }

    public GraphicsPathRendererFP(int width, int height) {
        this.reset(width, height);
        scanbuf = new int[4096];
        scanbuf_tmp = new int[4096];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void drawPath(GraphicsPathFP path, BrushFP style, int mode) {
        this.scanIndex = 0;
        this.drawMode = mode;
        path.visit(this);
        GraphicsPathRendererFP.radixSort(scanbuf, scanbuf_tmp, this.scanIndex);
        this.fillStyle = style;
        if (this.transformMatrix != null) {
            this.fillStyle.setGraphicsMatrix(this.transformMatrix);
        }
        this.drawBuffer();
        this.fillStyle = null;
    }

    public void drawPath(GraphicsPathFP path, MatrixFP matrix, BrushFP fillStyle, int mode) {
        this.transformMatrix = matrix;
        this.drawPath(path, fillStyle, mode);
        this.transformMatrix = null;
    }

    public void reset(int width, int height) {
        this.buffer = new int[width * height];
        this.width = width;
        this.height = height;
        this.setClip(0, 0, width, height);
    }

    public void clear(int color) {
        this.backGroundColor = color;
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = color;
        }
        this.setClip(0, 0, this.width, this.height);
    }

    public void finalizeBuffer(int color) {
        this.backGroundColor = color;
        ColorFP bk = ColorFP.fromArgb(color);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!this.clipContains(x, y)) continue;
                ColorFP c = ColorFP.fromArgb(this.buffer[x + y * this.width]);
                if (c.alpha != 0) {
                    if (c.alpha == 255) continue;
                    this.buffer[x + y * this.width] = ColorFP.fromArgb((int)(c.red * c.alpha + (255 - c.alpha) * bk.red >> 8), (int)(c.green * c.alpha + (255 - c.alpha) * bk.green >> 8), (int)(c.blue * c.alpha + (255 - c.alpha) * bk.blue >> 8)).value;
                    continue;
                }
                this.buffer[x + y * this.width] = color;
            }
        }
    }

    @Override
    public void moveTo(PointFP point) {
        this.transformedPoint = new PointFP(point);
        if (this.transformMatrix != null) {
            this.transformedPoint.transform(this.transformMatrix);
        }
        super.moveTo(point);
    }

    @Override
    public void lineTo(PointFP point) {
        PointFP pntTemp = new PointFP(point);
        this.ff_xmin = MathFP.min(this.ff_xmin, this.currentPoint().x);
        this.ff_xmax = MathFP.max(this.ff_xmax, point.x);
        this.ff_ymin = MathFP.min(this.ff_ymin, this.currentPoint().y);
        this.ff_ymax = MathFP.max(this.ff_ymax, point.y);
        if (this.transformMatrix != null) {
            pntTemp.transform(this.transformMatrix);
        }
        this.scanline(this.transformedPoint.x, this.transformedPoint.y, pntTemp.x, pntTemp.y);
        this.transformedPoint = pntTemp;
        super.lineTo(point);
    }

    public void setClip(int x, int y, int width, int height) {
        this.clipX = x;
        this.clipY = y;
        this.clipHeight = height;
        this.clipWidth = width;
    }

    private boolean clipContains(int x, int y) {
        return this.clipX <= x && x <= this.clipX + this.clipWidth && this.clipY <= y && y <= this.clipY + this.clipHeight;
    }

    private static void radixSort(int[] data_src, int[] data_tmp, int num) {
        int[] src = data_src;
        int[] dst = data_tmp;
        for (int shift = 0; shift <= 24; shift += 8) {
            int i;
            for (i = 0; i < 256; ++i) {
                GraphicsPathRendererFP.counts[i] = 0;
            }
            for (i = 0; i < num; ++i) {
                int n = src[i] >> shift & 0xFF;
                counts[n] = counts[n] + 1;
            }
            int indexnow = 0;
            for (i = 0; i < 256; ++i) {
                GraphicsPathRendererFP.index[i] = indexnow;
                indexnow += counts[i];
            }
            for (i = 0; i < num; ++i) {
                int n = src[i] >> shift & 0xFF;
                int n2 = index[n];
                index[n] = n2 + 1;
                dst[n2] = src[i];
            }
            int[] tmp = src;
            src = dst;
            dst = tmp;
        }
    }

    private void drawBuffer() {
        int curd = 0;
        int cure = 0;
        int cura = 0;
        int cula = 0;
        int cury = 0;
        int curx = 0;
        int curs = 0;
        int count = this.scanIndex;
        for (int c = 0; c <= count; ++c) {
            curs = c == count ? 0 : scanbuf[c];
            int newy = curs >> 17 & 0x7FF;
            int newx = curs >> 5 & 0xFFF;
            if (newx != curx || newy != cury) {
                int alp = 256 * cure / 4 + 256 * cula / 60 + 256 * cura / 60;
                if (alp != 0 && (alp = this.drawMode == 1 ? ((alp & 0x100) != 0 ? 255 - (alp & 0xFF) : alp & 0xFF) : MathFP.min(255, MathFP.abs(alp))) != 0) {
                    this.mergePixels(curx, cury, 1, alp);
                }
                cure = curd;
                if (newy == cury) {
                    if (curd != 0 && (alp = 256 * curd / 4) != 0 && (alp = this.drawMode == 1 ? ((alp & 0x100) != 0 ? 255 - (alp & 0xFF) : alp & 0xFF) : MathFP.min(255, MathFP.abs(alp))) != 0) {
                        this.mergePixels(curx + 1, cury, newx - curx - 1, alp);
                    }
                } else {
                    cury = newy;
                    cure = 0;
                    curd = 0;
                }
                curx = newx;
                cula = 0;
                cura = 0;
            }
            if ((curs & 1) != 0) {
                ++curd;
                cula += ~(curs >> 1) & 0xF;
                continue;
            }
            --curd;
            cura -= ~(curs >> 1) & 0xF;
        }
    }

    private void scanline(int ff_sx, int ff_sy, int ff_ex, int ff_ey) {
        int d;
        int dire;
        int sx = ff_sx >> 12;
        int ex = ff_ex >> 12;
        int sy = ff_sy * 4 >> 16;
        int ey = ff_ey * 4 >> 16;
        int xmin = MathFP.min(sx, ex);
        int xmax = MathFP.max(sx, ex);
        int ymin = MathFP.min(sy, ey);
        int ymax = MathFP.max(sy, ey);
        int incx = ff_sx < ff_ex && ff_sy < ff_ey || ff_sx >= ff_ex && ff_sy >= ff_ey ? 1 : -1;
        int x = incx == 1 ? xmin : xmax;
        int n = dire = ff_sy < ff_ey ? 1 : 0;
        if (ymin < 0 && ymax < 0 || ymin >= this.height * 4 && ymax >= this.height * 4) {
            return;
        }
        int n2 = MathFP.abs(xmax - xmin);
        int i = d = MathFP.abs(ymax - ymin);
        ymax = MathFP.min(ymax, this.height * 4);
        for (int y = ymin; y < ymax; ++y) {
            if (y >= 0) {
                if (this.scanIndex >= scanbuf.length) {
                    int bufSize = this.scanIndex / 2048;
                    if ((this.scanIndex + 1) % 2048 != 0) {
                        ++bufSize;
                    }
                    scanbuf_tmp = new int[bufSize * 2048];
                    System.arraycopy(scanbuf, 0, scanbuf_tmp, 0, this.scanIndex);
                    scanbuf = new int[bufSize * 2048];
                    System.arraycopy(scanbuf_tmp, 0, scanbuf, 0, this.scanIndex);
                    System.gc();
                    System.gc();
                }
                GraphicsPathRendererFP.scanbuf[this.scanIndex++] = y / 4 << 17 | MathFP.max(0, MathFP.min(this.width * 16 - 1, x)) << 1 | dire;
            }
            if ((i += n2) <= d) continue;
            int idivd = (i - 1) / d;
            x += incx * idivd;
            i -= d * idivd;
        }
    }

    private void mergePixels(int x, int y, int count, int opacity) {
        boolean isMonoColor = this.fillStyle.isMonoColor();
        int color = 0;
        if (isMonoColor) {
            color = this.fillStyle.getNextColor();
            color = (color >> 24 & 0xFF) * opacity >> 8 << 24 | color & 0xFFFFFF;
        }
        int lastBackColor = 0;
        int lastMergedColor = 0;
        for (int i = 0; i < count; ++i) {
            if (!this.clipContains(x + i, y)) continue;
            int bkColor = this.buffer[x + i + y * this.width];
            if (!isMonoColor) {
                int n = i == 0 ? this.fillStyle.getColorAt(x + i, y, count == 1) : (color = this.fillStyle.getNextColor());
                if (opacity != 255) {
                    color = (color >> 24 & 0xFF) * opacity >> 8 << 24 | color & 0xFFFFFF;
                }
            }
            if (lastBackColor == bkColor && isMonoColor) {
                this.buffer[x + i + y * this.width] = lastMergedColor;
                continue;
            }
            this.buffer[x + i + y * this.width] = GraphicsPathRendererFP.merge(bkColor, color);
            lastBackColor = bkColor;
            lastMergedColor = this.buffer[x + i + y * this.width];
        }
    }

    private static int merge(int color1, int color2) {
        int a2 = color2 >> 24 & 0xFF;
        if (a2 == 255 || color1 == 0) {
            return color2;
        }
        if (a2 == 0) {
            return color1;
        }
        int a1 = 255 - (color1 >> 24 & 0xFF);
        int a3 = 255 - a2;
        int b1 = color1 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int b2 = color2 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int Ca = 65025 - a1 * a3 >> 8;
        int Cr = r1 * a3 + r2 * a2 >> 8;
        int Cg = g1 * a3 + g2 * a2 >> 8;
        int Cb = b1 * a3 + b2 * a2 >> 8;
        return Ca << 24 | Cr << 16 | Cg << 8 | Cb;
    }
}

