/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.collections;

import java.util.Vector;

public class Hashtable {
    private final java.util.Hashtable hashtable;
    private final Vector vector;
    private final int MAX_LENGTH;
    private final Object syncRoot = new Object();

    public Hashtable(int maxLength) {
        this.MAX_LENGTH = maxLength;
        this.hashtable = new java.util.Hashtable(this.MAX_LENGTH);
        this.vector = new Vector(this.MAX_LENGTH);
    }

    public Hashtable() {
        this(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.vector.removeAllElements();
            this.hashtable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object value) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.hashtable.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.hashtable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.hashtable.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.hashtable.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.hashtable.get(key);
        }
    }

    public void addElement(Object obj) {
        this.put(obj, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHalfElements() {
        Object object = this.syncRoot;
        synchronized (object) {
            int totalSize = this.hashtable.size();
            for (int i = 0; i < totalSize / 2; ++i) {
                Object oldKey = this.vector.firstElement();
                this.hashtable.remove(oldKey);
                this.vector.removeElement(oldKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object object = null;
        Object object2 = this.syncRoot;
        synchronized (object2) {
            if (this.hashtable.size() > this.MAX_LENGTH) {
                for (int i = 0; i < this.MAX_LENGTH / 2; ++i) {
                    Object oldKey = this.vector.firstElement();
                    this.hashtable.remove(oldKey);
                    this.vector.removeElement(oldKey);
                }
            }
            object = this.hashtable.put(key, value);
            if (!this.vector.contains(key)) {
                this.vector.addElement(key);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllElements() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.vector.removeAllElements();
            this.hashtable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.vector.removeElement(key);
            return this.hashtable.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object keyAt(int index) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.vector.elementAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object firstElement() {
        Object object = this.syncRoot;
        synchronized (object) {
            Object key = this.vector.firstElement();
            return this.hashtable.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lastElement() {
        Object object = this.syncRoot;
        synchronized (object) {
            Object key = this.vector.lastElement();
            return this.hashtable.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object elementAt(int index) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (index < this.vector.size()) {
                Object key = this.vector.elementAt(index);
                return this.hashtable.get(key);
            }
            return null;
        }
    }

    public String toString() {
        return this.vector.toString() + this.hashtable.toString();
    }
}

