/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.assets.loaders;

import com.guidebee.game.engine.assets.AssetDescriptor;
import com.guidebee.game.engine.assets.AssetLoaderParameters;
import com.guidebee.game.engine.assets.AssetManager;
import com.guidebee.game.engine.assets.loaders.AsynchronousAssetLoader;
import com.guidebee.game.engine.assets.loaders.FileHandleResolver;
import com.guidebee.game.engine.assets.loaders.TextureLoader;
import com.guidebee.game.files.FileHandle;
import com.guidebee.game.graphics.BitmapFont;
import com.guidebee.game.graphics.Texture;
import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.utils.collections.Array;

public class BitmapFontLoader
extends AsynchronousAssetLoader<BitmapFont, BitmapFontParameter> {
    BitmapFont.BitmapFontData data;

    public BitmapFontLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, BitmapFontParameter parameter) {
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        if (parameter != null && parameter.bitmapFontData != null) {
            this.data = parameter.bitmapFontData;
            return deps;
        }
        this.data = new BitmapFont.BitmapFontData(file, parameter != null ? parameter.flip : false);
        for (int i = 0; i < this.data.getImagePaths().length; ++i) {
            TextureLoader.TextureParameter textureParams = new TextureLoader.TextureParameter();
            if (parameter != null) {
                textureParams.genMipMaps = parameter.genMipMaps;
                textureParams.minFilter = parameter.minFilter;
                textureParams.magFilter = parameter.magFilter;
            }
            AssetDescriptor<Texture> descriptor = new AssetDescriptor<Texture>(this.resolve(this.data.getImagePath(i)), Texture.class, textureParams);
            deps.add(descriptor);
        }
        return deps;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, BitmapFontParameter parameter) {
    }

    @Override
    public BitmapFont loadSync(AssetManager manager, String fileName, FileHandle file, BitmapFontParameter parameter) {
        TextureRegion[] regs = new TextureRegion[this.data.getImagePaths().length];
        for (int i = 0; i < regs.length; ++i) {
            regs[i] = new TextureRegion(manager.get(this.data.getImagePath(i), Texture.class));
        }
        return new BitmapFont(this.data, regs, true);
    }

    public static class BitmapFontParameter
    extends AssetLoaderParameters<BitmapFont> {
        public boolean flip = false;
        public boolean genMipMaps = false;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter magFilter = Texture.TextureFilter.Nearest;
        public BitmapFont.BitmapFontData bitmapFontData = null;
    }
}

