/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Dimension;
import com.guidebee.drawing.geometry.FlatteningPathIterator;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.drawing.geometry.MathFP;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.Rectangle;

public abstract class RectangularShape
implements IShape {
    protected RectangularShape() {
    }

    public abstract int getX();

    public abstract int getY();

    public abstract int getWidth();

    public abstract int getHeight();

    public int getMinX() {
        return this.getX();
    }

    public int getMinY() {
        return this.getY();
    }

    public int getMaxX() {
        return this.getX() + this.getWidth();
    }

    public int getMaxY() {
        return this.getY() + this.getHeight();
    }

    public int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getCenterY() {
        return this.getY() + this.getHeight() / 2;
    }

    public Rectangle getFrame() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public abstract boolean isEmpty();

    public abstract void setFrame(int var1, int var2, int var3, int var4);

    public void setFrame(Point loc, Dimension size) {
        this.setFrame(loc.getX(), loc.getY(), size.getWidth(), size.getHeight());
    }

    public void setFrame(Rectangle r) {
        this.setFrame(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void setFrameFromDiagonal(int x1, int y1, int x2, int y2) {
        int t;
        if (x2 < x1) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y2 < y1) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        this.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public void setFrameFromDiagonal(Point p1, Point p2) {
        this.setFrameFromDiagonal(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setFrameFromCenter(int centerX, int centerY, int cornerX, int cornerY) {
        int halfW = Math.abs(cornerX - centerX);
        int halfH = Math.abs(cornerY - centerY);
        this.setFrame(centerX - halfW, centerY - halfH, halfW * 2, halfH * 2);
    }

    public void setFrameFromCenter(Point center, Point corner) {
        this.setFrameFromCenter(center.getX(), center.getY(), corner.getX(), corner.getY());
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.intersects(r.x, r.y, r.width, r.height);
    }

    @Override
    public boolean contains(Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    @Override
    public Rectangle getBounds() {
        long width = this.getWidth();
        long height = this.getHeight();
        if (width < 0L || height < 0L) {
            return new Rectangle();
        }
        long x = this.getX();
        long y = this.getY();
        long x1 = MathFP.floor(x);
        long y1 = MathFP.floor(y);
        long x2 = MathFP.ceil(x + width);
        long y2 = MathFP.ceil(y + height);
        return new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at, int flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }
}

