/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.Rectangle;
import java.util.NoSuchElementException;

class RectIterator
implements IPathIterator {
    int x;
    int y;
    int w;
    int h;
    AffineTransform affine;
    int index;

    RectIterator(Rectangle r, AffineTransform at) {
        this.x = r.getX();
        this.y = r.getY();
        this.w = r.getWidth();
        this.h = r.getHeight();
        this.affine = at;
        if (this.w < 0 || this.h < 0) {
            this.index = 6;
        }
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 5;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(int[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("rect iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        coords[0] = this.x;
        coords[1] = this.y;
        if (this.index == 1 || this.index == 2) {
            coords[0] = coords[0] + this.w;
        }
        if (this.index == 2 || this.index == 3) {
            coords[1] = coords[1] + this.h;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }
}

