/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.QuadCurve;
import java.util.NoSuchElementException;

class QuadIterator
implements IPathIterator {
    QuadCurve quad;
    AffineTransform affine;
    int index;

    QuadIterator(QuadCurve q, AffineTransform at) {
        this.quad = q;
        this.affine = at;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(int[] coords) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("quad iterator iterator out of bounds");
        }
        if (this.index == 0) {
            coords[0] = this.quad.getX1();
            coords[1] = this.quad.getY1();
            type = 0;
        } else {
            coords[0] = this.quad.getCtrlX();
            coords[1] = this.quad.getCtrlY();
            coords[2] = this.quad.getX2();
            coords[3] = this.quad.getY2();
            type = 2;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }
}

