/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.FlatteningPathIterator;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.drawing.geometry.Line;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.QuadIterator;
import com.guidebee.drawing.geometry.Rectangle;

public class QuadCurve
implements IShape {
    public double x1;
    public double y1;
    public double ctrlx;
    public double ctrly;
    public double x2;
    public double y2;
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    public QuadCurve() {
    }

    public QuadCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        this.setCurve(x1, y1, ctrlx, ctrly, x2, y2);
    }

    public int getX1() {
        return (int)(this.x1 + 0.5);
    }

    public int getY1() {
        return (int)(this.y1 + 0.5);
    }

    public Point getP1() {
        return new Point((int)(this.x1 + 0.5), (int)(this.y1 + 0.5));
    }

    public int getCtrlX() {
        return (int)(this.ctrlx + 0.5);
    }

    public int getCtrlY() {
        return (int)(this.ctrly + 0.5);
    }

    public Point getCtrlPt() {
        return new Point((int)(this.ctrlx + 0.5), (int)(this.ctrly + 0.5));
    }

    public int getX2() {
        return (int)(this.x2 + 0.5);
    }

    public int getY2() {
        return (int)(this.y2 + 0.5);
    }

    public Point getP2() {
        return new Point((int)(this.x2 + 0.5), (int)(this.y2 + 0.5));
    }

    public void setCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.ctrlx = ctrlx;
        this.ctrly = ctrly;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public Rectangle getBounds() {
        double left = Math.min(Math.min(this.x1, this.x2), this.ctrlx);
        double top = Math.min(Math.min(this.y1, this.y2), this.ctrly);
        double right = Math.max(Math.max(this.x1, this.x2), this.ctrlx);
        double bottom = Math.max(Math.max(this.y1, this.y2), this.ctrly);
        return new Rectangle((int)(left + 0.5), (int)(top + 0.5), (int)(right - left + 0.5), (int)(bottom - top + 0.5));
    }

    public void setCurve(double[] coords, int offset) {
        this.setCurve(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5]);
    }

    public void setCurve(Point p1, Point cp, Point p2) {
        this.setCurve(p1.getX(), p1.getY(), cp.getX(), cp.getY(), p2.getX(), p2.getY());
    }

    public void setCurve(Point[] pts, int offset) {
        this.setCurve(pts[offset + 0].getX(), pts[offset + 0].getY(), pts[offset + 1].getX(), pts[offset + 1].getY(), pts[offset + 2].getX(), pts[offset + 2].getY());
    }

    public void setCurve(QuadCurve c) {
        this.setCurve(c.getX1(), c.getY1(), c.getCtrlX(), c.getCtrlY(), c.getX2(), c.getY2());
    }

    public static int getFlatnessSq(int x1, int y1, int ctrlx, int ctrly, int x2, int y2) {
        return Line.ptSegDistSq(x1, y1, x2, y2, ctrlx, ctrly);
    }

    public static int getFlatness(int x1, int y1, int ctrlx, int ctrly, int x2, int y2) {
        return Line.ptSegDist(x1, y1, x2, y2, ctrlx, ctrly);
    }

    public static int getFlatnessSq(int[] coords, int offset) {
        return Line.ptSegDistSq(coords[offset + 0], coords[offset + 1], coords[offset + 4], coords[offset + 5], coords[offset + 2], coords[offset + 3]);
    }

    public static int getFlatness(int[] coords, int offset) {
        return Line.ptSegDist(coords[offset + 0], coords[offset + 1], coords[offset + 4], coords[offset + 5], coords[offset + 2], coords[offset + 3]);
    }

    public double getFlatnessSq() {
        return Line.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public double getFlatness() {
        return Line.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public void subdivide(QuadCurve left, QuadCurve right) {
        QuadCurve.subdivide(this, left, right);
    }

    public static void subdivide(QuadCurve src, QuadCurve left, QuadCurve right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double ctrlx = src.getCtrlX();
        double ctrly = src.getCtrlY();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double ctrlx1 = (x1 + ctrlx) / 2.0;
        double ctrly1 = (y1 + ctrly) / 2.0;
        double ctrlx2 = (x2 + ctrlx) / 2.0;
        double ctrly2 = (y2 + ctrly) / 2.0;
        ctrlx = (ctrlx1 + ctrlx2) / 2.0;
        ctrly = (ctrly1 + ctrly2) / 2.0;
        if (left != null) {
            left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx, ctrly);
        }
        if (right != null) {
            right.setCurve(ctrlx, ctrly, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static void subdivide(double[] src, int srcoff, double[] left, int leftoff, double[] right, int rightoff) {
        double x1 = src[srcoff + 0];
        double y1 = src[srcoff + 1];
        double ctrlx = src[srcoff + 2];
        double ctrly = src[srcoff + 3];
        double x2 = src[srcoff + 4];
        double y2 = src[srcoff + 5];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
        x1 = (x1 + ctrlx) / 2.0;
        y1 = (y1 + ctrly) / 2.0;
        x2 = (x2 + ctrlx) / 2.0;
        y2 = (y2 + ctrly) / 2.0;
        ctrlx = (x1 + x2) / 2.0;
        ctrly = (y1 + y2) / 2.0;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx;
            left[leftoff + 5] = ctrly;
        }
        if (right != null) {
            right[rightoff + 0] = ctrlx;
            right[rightoff + 1] = ctrly;
            right[rightoff + 2] = x2;
            right[rightoff + 3] = y2;
        }
    }

    public static int solveQuadratic(double[] eqn) {
        return QuadCurve.solveQuadratic(eqn, eqn);
    }

    public static int solveQuadratic(double[] eqn, double[] res) {
        double a = eqn[2];
        double b = eqn[1];
        double c = eqn[0];
        int roots = 0;
        if (a == 0.0) {
            if (b == 0.0) {
                return -1;
            }
            res[roots++] = -c / b;
        } else {
            double d = b * b - 4.0 * a * c;
            if (d < 0.0) {
                return 0;
            }
            d = Math.sqrt(d);
            if (b < 0.0) {
                d = -d;
            }
            double q = (b + d) / -2.0;
            res[roots++] = q / a;
            if (q != 0.0) {
                res[roots++] = c / q;
            }
        }
        return roots;
    }

    @Override
    public boolean contains(int x, int y) {
        double dyl;
        double dxl;
        double kx;
        double dy;
        double xp1 = this.getX1();
        double yp1 = this.getY1();
        double xc = this.getCtrlX();
        double yc = this.getCtrlY();
        double xp2 = this.getX2();
        double dx = (double)x - xp1;
        double yp2 = this.getY2();
        double ky = yp1 - 2.0 * yc + yp2;
        double t0 = (dx * ky - (dy = (double)y - yp1) * (kx = xp1 - 2.0 * xc + xp2)) / ((dxl = xp2 - xp1) * ky - (dyl = yp2 - yp1) * kx);
        if (t0 < 0.0 || t0 > 1.0 || t0 != t0) {
            return false;
        }
        double xb = kx * t0 * t0 + 2.0 * (xc - xp1) * t0 + xp1;
        double yb = ky * t0 * t0 + 2.0 * (yc - yp1) * t0 + yp1;
        double xl = dxl * t0 + xp1;
        double yl = dyl * t0 + yp1;
        return (double)x >= xb && (double)x < xl || (double)x >= xl && (double)x < xb || (double)y >= yb && (double)y < yl || (double)y >= yl && (double)y < yb;
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    private static void fillEqn(double[] eqn, double val, double c1, double cp, double c2) {
        eqn[0] = c1 - val;
        eqn[1] = cp + cp - c1 - c1;
        eqn[2] = c1 - cp - cp + c2;
    }

    private static int evalQuadratic(double[] vals, int num, boolean include0, boolean include1, double[] inflect, double c1, double ctrl, double c2) {
        int j = 0;
        for (int i = 0; i < num; ++i) {
            double t = vals[i];
            if (!(include0 ? t >= 0.0 : t > 0.0) || !(include1 ? t <= 1.0 : t < 1.0) || inflect != null && inflect[1] + 2.0 * inflect[2] * t == 0.0) continue;
            double u = 1.0 - t;
            vals[j++] = c1 * u * u + 2.0 * ctrl * t * u + c2 * t * t;
        }
        return j;
    }

    private static int getTag(double coord, double low, double high) {
        if (coord <= low) {
            return coord < low ? -2 : -1;
        }
        if (coord >= high) {
            return coord > high ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int pttag, int opt1tag, int opt2tag) {
        switch (pttag) {
            default: {
                return false;
            }
            case -1: {
                return opt1tag >= 0 || opt2tag >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return opt1tag <= 0 || opt2tag <= 0;
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        int c2tag;
        boolean yoverlap;
        if (w <= 0 || h <= 0) {
            return false;
        }
        double xp1 = this.getX1();
        double yp1 = this.getY1();
        int x1tag = QuadCurve.getTag(xp1, x, x + w);
        int y1tag = QuadCurve.getTag(this.y1, y, y + h);
        if (x1tag == 0 && y1tag == 0) {
            return true;
        }
        double xp2 = this.getX2();
        double yp2 = this.getY2();
        int x2tag = QuadCurve.getTag(xp2, x, x + w);
        int y2tag = QuadCurve.getTag(yp2, y, y + h);
        if (x2tag == 0 && y2tag == 0) {
            return true;
        }
        double ctrlpx = this.getCtrlX();
        double ctrlpy = this.getCtrlY();
        int ctrlxtag = QuadCurve.getTag(ctrlpx, x, x + w);
        int ctrlytag = QuadCurve.getTag(ctrlpy, y, y + h);
        if (x1tag < 0 && x2tag < 0 && ctrlxtag < 0) {
            return false;
        }
        if (y1tag < 0 && y2tag < 0 && ctrlytag < 0) {
            return false;
        }
        if (x1tag > 0 && x2tag > 0 && ctrlxtag > 0) {
            return false;
        }
        if (y1tag > 0 && y2tag > 0 && ctrlytag > 0) {
            return false;
        }
        if (QuadCurve.inwards(x1tag, x2tag, ctrlxtag) && QuadCurve.inwards(y1tag, y2tag, ctrlytag)) {
            return true;
        }
        if (QuadCurve.inwards(x2tag, x1tag, ctrlxtag) && QuadCurve.inwards(y2tag, y1tag, ctrlytag)) {
            return true;
        }
        boolean xoverlap = x1tag * x2tag <= 0;
        boolean bl = yoverlap = y1tag * y2tag <= 0;
        if (x1tag == 0 && x2tag == 0 && yoverlap) {
            return true;
        }
        if (y1tag == 0 && y2tag == 0 && xoverlap) {
            return true;
        }
        double[] eqn = new double[3];
        double[] res = new double[3];
        if (!yoverlap) {
            QuadCurve.fillEqn(eqn, y1tag < 0 ? y : y + h, this.y1, ctrlpy, yp2);
            return QuadCurve.solveQuadratic(eqn, res) == 2 && QuadCurve.evalQuadratic(res, 2, true, true, null, xp1, ctrlpx, xp2) == 2 && QuadCurve.getTag(res[0], x, x + w) * QuadCurve.getTag(res[1], x, x + w) <= 0;
        }
        if (!xoverlap) {
            QuadCurve.fillEqn(eqn, x1tag < 0 ? x : x + w, xp1, ctrlpx, xp2);
            return QuadCurve.solveQuadratic(eqn, res) == 2 && QuadCurve.evalQuadratic(res, 2, true, true, null, this.y1, ctrlpy, yp2) == 2 && QuadCurve.getTag(res[0], y, y + h) * QuadCurve.getTag(res[1], y, y + h) <= 0;
        }
        double dx = xp2 - xp1;
        double dy = yp2 - this.y1;
        double k = yp2 * xp1 - xp2 * this.y1;
        int c1tag = y1tag == 0 ? x1tag : QuadCurve.getTag((k + dx * (double)(y1tag < 0 ? y : y + h)) / dy, x, x + w);
        if (c1tag * (c2tag = y2tag == 0 ? x2tag : QuadCurve.getTag((k + dx * (double)(y2tag < 0 ? y : y + h)) / dy, x, x + w)) <= 0) {
            return true;
        }
        c1tag = c1tag * x1tag <= 0 ? y1tag : y2tag;
        QuadCurve.fillEqn(eqn, c2tag < 0 ? x : x + w, xp1, ctrlpx, xp2);
        int num = QuadCurve.solveQuadratic(eqn, res);
        QuadCurve.evalQuadratic(res, num, true, true, null, this.y1, ctrlpy, yp2);
        c2tag = QuadCurve.getTag(res[0], y, y + h);
        return c1tag * c2tag <= 0;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return false;
        }
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x + w, y + h) && this.contains(x, y + h);
    }

    @Override
    public boolean contains(Rectangle r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        return new QuadIterator(this, at);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at, int flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }
}

