/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Ellipse;
import com.guidebee.drawing.geometry.IPathIterator;
import java.util.NoSuchElementException;

class EllipseIterator
implements IPathIterator {
    double x;
    double y;
    double w;
    double h;
    AffineTransform affine;
    int index;
    public static final double CtrlVal = 0.5522847498307933;
    private static final double pcv = 0.7761423749153966;
    private static final double ncv = 0.22385762508460333;
    private static double[][] ctrlpts = new double[][]{{1.0, 0.7761423749153966, 0.7761423749153966, 1.0, 0.5, 1.0}, {0.22385762508460333, 1.0, 0.0, 0.7761423749153966, 0.0, 0.5}, {0.0, 0.22385762508460333, 0.22385762508460333, 0.0, 0.5, 0.0}, {0.7761423749153966, 0.0, 1.0, 0.22385762508460333, 1.0, 0.5}};

    EllipseIterator(Ellipse e, AffineTransform at) {
        this.x = e.getX();
        this.y = e.getY();
        this.w = e.getWidth();
        this.h = e.getHeight();
        this.affine = at;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index = 6;
        }
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 5;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(int[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("ellipse iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        if (this.index == 0) {
            double[] ctrls = ctrlpts[3];
            coords[0] = (int)(this.x + ctrls[4] * this.w + 0.5);
            coords[1] = (int)(this.y + ctrls[5] * this.h + 0.5);
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 0;
        }
        double[] ctrls = ctrlpts[this.index - 1];
        coords[0] = (int)(this.x + ctrls[0] * this.w + 0.5);
        coords[1] = (int)(this.y + ctrls[1] * this.h + 0.5);
        coords[2] = (int)(this.x + ctrls[2] * this.w + 0.5);
        coords[3] = (int)(this.y + ctrls[3] * this.h + 0.5);
        coords[4] = (int)(this.x + ctrls[4] * this.w + 0.5);
        coords[5] = (int)(this.y + ctrls[5] * this.h + 0.5);
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }
}

