/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.CubicCurve;
import com.guidebee.drawing.geometry.IPathIterator;
import java.util.NoSuchElementException;

class CubicIterator
implements IPathIterator {
    CubicCurve cubic;
    AffineTransform affine;
    int index;

    CubicIterator(CubicCurve q, AffineTransform at) {
        this.cubic = q;
        this.affine = at;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(int[] coords) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("cubic iterator iterator out of bounds");
        }
        if (this.index == 0) {
            coords[0] = this.cubic.getX1();
            coords[1] = this.cubic.getY1();
            type = 0;
        } else {
            coords[0] = this.cubic.getCtrlX1();
            coords[1] = this.cubic.getCtrlY1();
            coords[2] = this.cubic.getCtrlX2();
            coords[3] = this.cubic.getCtrlY2();
            coords[4] = this.cubic.getX2();
            coords[5] = this.cubic.getY2();
            type = 3;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 3);
        }
        return type;
    }
}

