/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.CubicIterator;
import com.guidebee.drawing.geometry.Curve;
import com.guidebee.drawing.geometry.FlatteningPathIterator;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.drawing.geometry.Line;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.QuadCurve;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.game.engine.collections.Arrays;
import com.guidebee.game.engine.math.MathEx;

public class CubicCurve
implements IShape {
    public double x1;
    public double y1;
    public double ctrlx1;
    public double ctrly1;
    public double ctrlx2;
    public double ctrly2;
    public double x2;
    public double y2;
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    public CubicCurve() {
    }

    public CubicCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        this.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
    }

    public int getX1() {
        return (int)(this.x1 + 0.5);
    }

    public int getY1() {
        return (int)(this.y1 + 0.5);
    }

    public Point getP1() {
        return new Point((int)(this.x1 + 0.5), (int)(this.y1 + 0.5));
    }

    public int getCtrlX1() {
        return (int)(this.ctrlx1 + 0.5);
    }

    public int getCtrlY1() {
        return (int)(this.ctrly1 + 0.5);
    }

    public Point getCtrlP1() {
        return new Point((int)(this.ctrlx1 + 0.5), (int)(this.ctrly1 + 0.5));
    }

    public int getCtrlX2() {
        return (int)(this.ctrlx2 + 0.5);
    }

    public int getCtrlY2() {
        return (int)(this.ctrly2 + 0.5);
    }

    public Point getCtrlP2() {
        return new Point((int)(this.ctrlx2 + 0.5), (int)(this.ctrly2 + 0.5));
    }

    public int getX2() {
        return (int)(this.x2 + 0.5);
    }

    public int getY2() {
        return (int)(this.y2 + 0.5);
    }

    public Point getP2() {
        return new Point((int)(this.x2 + 0.5), (int)(this.y2 + 0.5));
    }

    public void setCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.ctrlx1 = ctrlx1;
        this.ctrly1 = ctrly1;
        this.ctrlx2 = ctrlx2;
        this.ctrly2 = ctrly2;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public Rectangle getBounds() {
        double left = MathEx.min(MathEx.min(this.x1, this.x2), MathEx.min(this.ctrlx1, this.ctrlx2));
        double top = MathEx.min(MathEx.min(this.y1, this.y2), MathEx.min(this.ctrly1, this.ctrly2));
        double right = MathEx.max(MathEx.max(this.x1, this.x2), MathEx.max(this.ctrlx1, this.ctrlx2));
        double bottom = MathEx.max(MathEx.max(this.y1, this.y2), MathEx.max(this.ctrly1, this.ctrly2));
        return new Rectangle((int)(left + 0.5), (int)(top + 0.5), (int)(right - left + 0.5), (int)(bottom - top + 0.5));
    }

    public void setCurve(double[] coords, int offset) {
        this.setCurve(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public void setCurve(Point p1, Point cp1, Point cp2, Point p2) {
        this.setCurve(p1.getX(), p1.getY(), cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), p2.getX(), p2.getY());
    }

    public void setCurve(Point[] pts, int offset) {
        this.setCurve(pts[offset + 0].getX(), pts[offset + 0].getY(), pts[offset + 1].getX(), pts[offset + 1].getY(), pts[offset + 2].getX(), pts[offset + 2].getY(), pts[offset + 3].getX(), pts[offset + 3].getY());
    }

    public void setCurve(CubicCurve c) {
        this.setCurve(c.getX1(), c.getY1(), c.getCtrlX1(), c.getCtrlY1(), c.getCtrlX2(), c.getCtrlY2(), c.getX2(), c.getY2());
    }

    public static int getFlatnessSq(int x1, int y1, int ctrlx1, int ctrly1, int ctrlx2, int ctrly2, int x2, int y2) {
        return MathEx.max(Line.ptSegDistSq(x1, y1, x2, y2, ctrlx1, ctrly1), Line.ptSegDistSq(x1, y1, x2, y2, ctrlx2, ctrly2));
    }

    public static int getFlatness(int x1, int y1, int ctrlx1, int ctrly1, int ctrlx2, int ctrly2, int x2, int y2) {
        return (int)(MathEx.sqrt(CubicCurve.getFlatnessSq(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2)) + 0.5);
    }

    public static int getFlatnessSq(int[] coords, int offset) {
        return CubicCurve.getFlatnessSq(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public static int getFlatness(int[] coords, int offset) {
        return CubicCurve.getFlatness(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public int getFlatnessSq() {
        return CubicCurve.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public int getFlatness() {
        return CubicCurve.getFlatness(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public void subdivide(CubicCurve left, CubicCurve right) {
        CubicCurve.subdivide(this, left, right);
    }

    public static void subdivide(CubicCurve src, CubicCurve left, CubicCurve right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double ctrlx1 = src.getCtrlX1();
        double ctrly1 = src.getCtrlY1();
        double ctrlx2 = src.getCtrlX2();
        double ctrly2 = src.getCtrlY2();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + ctrlx1) / 2.0;
        ctrly1 = (y1 + ctrly1) / 2.0;
        ctrlx2 = (x2 + ctrlx2) / 2.0;
        ctrly2 = (y2 + ctrly2) / 2.0;
        double ctrlx12 = (ctrlx1 + centerx) / 2.0;
        double ctrly12 = (ctrly1 + centery) / 2.0;
        double ctrlx21 = (ctrlx2 + centerx) / 2.0;
        double ctrly21 = (ctrly2 + centery) / 2.0;
        centerx = (ctrlx12 + ctrlx21) / 2.0;
        centery = (ctrly12 + ctrly21) / 2.0;
        if (left != null) {
            left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx12, ctrly12, centerx, centery);
        }
        if (right != null) {
            right.setCurve(centerx, centery, ctrlx21, ctrly21, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static void subdivide(double[] src, int srcoff, double[] left, int leftoff, double[] right, int rightoff) {
        double x1 = src[srcoff + 0];
        double y1 = src[srcoff + 1];
        double ctrlx1 = src[srcoff + 2];
        double ctrly1 = src[srcoff + 3];
        double ctrlx2 = src[srcoff + 4];
        double ctrly2 = src[srcoff + 5];
        double x2 = src[srcoff + 6];
        double y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 = (x1 + ctrlx1) / 2.0;
        y1 = (y1 + ctrly1) / 2.0;
        x2 = (x2 + ctrlx2) / 2.0;
        y2 = (y2 + ctrly2) / 2.0;
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + centerx) / 2.0;
        ctrly1 = (y1 + centery) / 2.0;
        ctrlx2 = (x2 + centerx) / 2.0;
        ctrly2 = (y2 + centery) / 2.0;
        centerx = (ctrlx1 + ctrlx2) / 2.0;
        centery = (ctrly1 + ctrly2) / 2.0;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    public static int solveCubic(double[] eqn) {
        return CubicCurve.solveCubic(eqn, eqn);
    }

    public static int solveCubic(double[] eqn, double[] res) {
        double d = eqn[3];
        if (d == 0.0) {
            return QuadCurve.solveQuadratic(eqn, res);
        }
        double a = eqn[2] / d;
        double b = eqn[1] / d;
        double c = eqn[0] / d;
        int roots = 0;
        double Q = (a * a - 3.0 * b) / 9.0;
        double R = (2.0 * a * a * a - 9.0 * a * b + 27.0 * c) / 54.0;
        double R2 = R * R;
        double Q3 = Q * Q * Q;
        a /= 3.0;
        if (R2 < Q3) {
            double theta = MathEx.acos(R / MathEx.sqrt(Q3));
            Q = -2.0 * MathEx.sqrt(Q);
            if (res == eqn) {
                eqn = new double[4];
                System.arraycopy(res, 0, eqn, 0, 4);
            }
            res[roots++] = Q * MathEx.cos(theta / 3.0) - a;
            res[roots++] = Q * MathEx.cos((theta + Math.PI * 2) / 3.0) - a;
            res[roots++] = Q * MathEx.cos((theta - Math.PI * 2) / 3.0) - a;
            CubicCurve.fixRoots(res, eqn);
        } else {
            boolean neg = R < 0.0;
            double S = MathEx.sqrt(R2 - Q3);
            if (neg) {
                R = -R;
            }
            double A = MathEx.pow(R + S, 0.3333333333333333);
            if (!neg) {
                A = -A;
            }
            double B = A == 0.0 ? 0.0 : Q / A;
            res[roots++] = A + B - a;
        }
        return roots;
    }

    @Override
    public boolean contains(int x, int y) {
        double yp2;
        double xp2;
        double yp1;
        if ((double)x * 0.0 + (double)y * 0.0 != 0.0) {
            return false;
        }
        double xp1 = this.getX1();
        int crossings = Curve.pointCrossingsForLine(x, y, xp1, yp1 = (double)this.getY1(), xp2 = (double)this.getX2(), yp2 = (double)this.getY2()) + Curve.pointCrossingsForCubic(x, y, xp1, yp1, this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), xp2, yp2, 0);
        return (crossings & 1) == 1;
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        int c2tag;
        boolean yoverlap;
        if (w <= 0 || h <= 0) {
            return false;
        }
        double xp1 = this.getX1();
        double yp1 = this.getY1();
        int x1tag = CubicCurve.getTag(xp1, x, x + w);
        int y1tag = CubicCurve.getTag(yp1, y, y + h);
        if (x1tag == 0 && y1tag == 0) {
            return true;
        }
        double xp2 = this.getX2();
        double yp2 = this.getY2();
        int x2tag = CubicCurve.getTag(xp2, x, x + w);
        int y2tag = CubicCurve.getTag(yp2, y, y + h);
        if (x2tag == 0 && y2tag == 0) {
            return true;
        }
        double ctrlxp1 = this.getCtrlX1();
        double ctrlyp1 = this.getCtrlY1();
        double ctrlxp2 = this.getCtrlX2();
        double ctrlyp2 = this.getCtrlY2();
        int ctrlx1tag = CubicCurve.getTag(ctrlxp1, x, x + w);
        int ctrly1tag = CubicCurve.getTag(ctrlyp1, y, y + h);
        int ctrlx2tag = CubicCurve.getTag(ctrlxp2, x, x + w);
        int ctrly2tag = CubicCurve.getTag(ctrlyp2, y, y + h);
        if (x1tag < 0 && x2tag < 0 && ctrlx1tag < 0 && ctrlx2tag < 0) {
            return false;
        }
        if (y1tag < 0 && y2tag < 0 && ctrly1tag < 0 && ctrly2tag < 0) {
            return false;
        }
        if (x1tag > 0 && x2tag > 0 && ctrlx1tag > 0 && ctrlx2tag > 0) {
            return false;
        }
        if (y1tag > 0 && y2tag > 0 && ctrly1tag > 0 && ctrly2tag > 0) {
            return false;
        }
        if (CubicCurve.inwards(x1tag, x2tag, ctrlx1tag) && CubicCurve.inwards(y1tag, y2tag, ctrly1tag)) {
            return true;
        }
        if (CubicCurve.inwards(x2tag, x1tag, ctrlx2tag) && CubicCurve.inwards(y2tag, y1tag, ctrly2tag)) {
            return true;
        }
        boolean xoverlap = x1tag * x2tag <= 0;
        boolean bl = yoverlap = y1tag * y2tag <= 0;
        if (x1tag == 0 && x2tag == 0 && yoverlap) {
            return true;
        }
        if (y1tag == 0 && y2tag == 0 && xoverlap) {
            return true;
        }
        double[] eqn = new double[4];
        double[] res = new double[4];
        if (!yoverlap) {
            CubicCurve.fillEqn(eqn, y1tag < 0 ? y : y + h, yp1, ctrlyp1, ctrlyp2, yp2);
            int num = CubicCurve.solveCubic(eqn, res);
            num = CubicCurve.evalCubic(res, num, true, true, null, xp1, ctrlxp1, ctrlxp2, xp2);
            return num == 2 && CubicCurve.getTag(res[0], x, x + w) * CubicCurve.getTag(res[1], x, x + w) <= 0;
        }
        if (!xoverlap) {
            CubicCurve.fillEqn(eqn, x1tag < 0 ? x : x + w, xp1, ctrlxp1, ctrlxp2, xp2);
            int num = CubicCurve.solveCubic(eqn, res);
            num = CubicCurve.evalCubic(res, num, true, true, null, yp1, ctrlyp1, ctrlyp2, yp2);
            return num == 2 && CubicCurve.getTag(res[0], y, y + h) * CubicCurve.getTag(res[1], y, y + h) <= 0;
        }
        double dx = xp2 - xp1;
        double dy = yp2 - yp1;
        double k = yp2 * xp1 - xp2 * yp1;
        int c1tag = y1tag == 0 ? x1tag : CubicCurve.getTag((k + dx * (double)(y1tag < 0 ? y : y + h)) / dy, x, x + w);
        if (c1tag * (c2tag = y2tag == 0 ? x2tag : CubicCurve.getTag((k + dx * (double)(y2tag < 0 ? y : y + h)) / dy, x, x + w)) <= 0) {
            return true;
        }
        c1tag = c1tag * x1tag <= 0 ? y1tag : y2tag;
        CubicCurve.fillEqn(eqn, c2tag < 0 ? x : x + w, xp1, ctrlxp1, ctrlxp2, xp2);
        int num = CubicCurve.solveCubic(eqn, res);
        num = CubicCurve.evalCubic(res, num, true, true, null, yp1, ctrlyp1, ctrlyp2, yp2);
        int[] tags = new int[num + 1];
        for (int i = 0; i < num; ++i) {
            tags[i] = CubicCurve.getTag(res[i], y, y + h);
        }
        tags[num] = c1tag;
        Arrays.sort(tags);
        return num >= 1 && tags[0] * tags[1] <= 0 || num >= 3 && tags[2] * tags[3] <= 0;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return false;
        }
        if (!(this.contains(x, y) && this.contains(x + w, y) && this.contains(x + w, y + h) && this.contains(x, y + h))) {
            return false;
        }
        Rectangle rect = new Rectangle(x, y, w, h);
        return !rect.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    @Override
    public boolean contains(Rectangle r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        return new CubicIterator(this, at);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at, int flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    private static void fixRoots(double[] res, double[] eqn) {
        double EPSILON = 1.0E-5;
        for (int i = 0; i < 3; ++i) {
            double t = res[i];
            if (MathEx.abs(t) < 1.0E-5) {
                res[i] = CubicCurve.findZero(t, 0.0, eqn);
                continue;
            }
            if (!(MathEx.abs(t - 1.0) < 1.0E-5)) continue;
            res[i] = CubicCurve.findZero(t, 1.0, eqn);
        }
    }

    private static double solveEqn(double[] eqn, int order, double t) {
        double v = eqn[order];
        while (--order >= 0) {
            v = v * t + eqn[order];
        }
        return v;
    }

    private static double findZero(double t, double target, double[] eqn) {
        double[] slopeqn = new double[]{eqn[1], 2.0 * eqn[2], 3.0 * eqn[3]};
        double origdelta = 0.0;
        double origt = t;
        double slope;
        while ((slope = CubicCurve.solveEqn(slopeqn, 2, t)) != 0.0) {
            double newt;
            double y = CubicCurve.solveEqn(eqn, 3, t);
            if (y == 0.0) {
                return t;
            }
            double delta = -(y / slope);
            if (origdelta == 0.0) {
                origdelta = delta;
            }
            if (t < target) {
                if (delta < 0.0) {
                    return t;
                }
            } else if (t > target) {
                if (delta > 0.0) {
                    return t;
                }
            } else {
                return delta > 0.0 ? target + Double.MIN_VALUE : target - Double.MIN_VALUE;
            }
            if (t == (newt = t + delta)) {
                return t;
            }
            if (delta * origdelta < 0.0) {
                int tag;
                int n = tag = origt < t ? CubicCurve.getTag(target, origt, t) : CubicCurve.getTag(target, t, origt);
                if (tag != 0) {
                    return (origt + t) / 2.0;
                }
                t = target;
                continue;
            }
            t = newt;
        }
        return t;
    }

    private static void fillEqn(double[] eqn, double val, double c1, double cp1, double cp2, double c2) {
        eqn[0] = c1 - val;
        eqn[1] = (cp1 - c1) * 3.0;
        eqn[2] = (cp2 - cp1 - cp1 + c1) * 3.0;
        eqn[3] = c2 + (cp1 - cp2) * 3.0 - c1;
    }

    private static int evalCubic(double[] vals, int num, boolean include0, boolean include1, double[] inflect, double c1, double cp1, double cp2, double c2) {
        int j = 0;
        for (int i = 0; i < num; ++i) {
            double t = vals[i];
            if (!(include0 ? t >= 0.0 : t > 0.0) || !(include1 ? t <= 1.0 : t < 1.0) || inflect != null && inflect[1] + (2.0 * inflect[2] + 3.0 * inflect[3] * t) * t == 0.0) continue;
            double u = 1.0 - t;
            vals[j++] = c1 * u * u * u + 3.0 * cp1 * t * u * u + 3.0 * cp2 * t * t * u + c2 * t * t * t;
        }
        return j;
    }

    private static int getTag(double coord, double low, double high) {
        if (coord <= low) {
            return coord < low ? -2 : -1;
        }
        if (coord >= high) {
            return coord > high ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int pttag, int opt1tag, int opt2tag) {
        switch (pttag) {
            default: {
                return false;
            }
            case -1: {
                return opt1tag >= 0 || opt2tag >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return opt1tag <= 0 || opt2tag <= 0;
    }
}

