/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Arc;
import com.guidebee.drawing.geometry.IPathIterator;
import java.util.NoSuchElementException;

class ArcIterator
implements IPathIterator {
    double x;
    double y;
    double w;
    double h;
    double angStRad;
    double increment;
    double cv;
    AffineTransform affine;
    int index;
    int arcSegs;
    int lineSegs;

    ArcIterator(Arc a, AffineTransform at) {
        this.w = a.getWidth() / 2;
        this.h = a.getHeight() / 2;
        this.x = (double)a.getX() + this.w;
        this.y = (double)a.getY() + this.h;
        this.angStRad = -Math.toRadians(a.getAngleStart());
        this.affine = at;
        double ext = -a.getAngleExtent();
        if (ext >= 360.0 || ext <= -360.0) {
            this.arcSegs = 4;
            this.increment = 1.5707963267948966;
            this.cv = 0.5522847498307933;
            if (ext < 0.0) {
                this.increment = -this.increment;
                this.cv = -this.cv;
            }
        } else {
            this.arcSegs = (int)Math.ceil(Math.abs(ext) / 90.0);
            this.increment = Math.toRadians(ext / (double)this.arcSegs);
            this.cv = ArcIterator.btan(this.increment);
            if (this.cv == 0.0) {
                this.arcSegs = 0;
            }
        }
        switch (a.getArcType()) {
            case 0: {
                this.lineSegs = 0;
                break;
            }
            case 1: {
                this.lineSegs = 1;
                break;
            }
            case 2: {
                this.lineSegs = 2;
            }
        }
        if (this.w < 0.0 || this.h < 0.0) {
            this.lineSegs = -1;
            this.arcSegs = -1;
        }
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > this.arcSegs + this.lineSegs;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(int[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("arc iterator out of bounds");
        }
        double angle = this.angStRad;
        if (this.index == 0) {
            coords[0] = (int)(this.x + Math.cos(angle) * this.w + 0.5);
            coords[1] = (int)(this.y + Math.sin(angle) * this.h + 0.5);
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 0;
        }
        if (this.index > this.arcSegs) {
            if (this.index == this.arcSegs + this.lineSegs) {
                return 4;
            }
            coords[0] = (int)(this.x + 0.5);
            coords[1] = (int)(this.y + 0.5);
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 1;
        }
        double relx = Math.cos(angle += this.increment * (double)(this.index - 1));
        double rely = Math.sin(angle);
        coords[0] = (int)(this.x + (relx - this.cv * rely) * this.w + 0.5);
        coords[1] = (int)(this.y + (rely + this.cv * relx) * this.h + 0.5);
        relx = Math.cos(angle += this.increment);
        rely = Math.sin(angle);
        coords[2] = (int)(this.x + (relx + this.cv * rely) * this.w + 0.5);
        coords[3] = (int)(this.y + (rely - this.cv * relx) * this.h + 0.5);
        coords[4] = (int)(this.x + relx * this.w + 0.5);
        coords[5] = (int)(this.y + rely * this.h + 0.5);
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    private static double btan(double increment) {
        return 1.3333333333333333 * Math.sin(increment /= 2.0) / (1.0 + Math.cos(increment));
    }
}

